	-- ************************************************************************************************
-- *                                                                                              *
-- *                                                                                              *
-- *                                              EMS                                             *
-- *                                         CONFIGURATION                                        *
-- *                                                                                              *
-- *                                                                                              *
-- ************************************************************************************************

EMS_CustomMapConfig =
{
	-- ********************************************************************************************
	-- * Configuration File Version
	-- * A version check will make sure every player has the same version of the configuration file
	-- ********************************************************************************************
	Version = 4.2,
 
	-- ********************************************************************************************
	-- * Debug Mode
	-- * Activates the ems debug mode if set to true.
	-- * This will enable key bindings to achieve some common debug tasks.
	-- * Ingame a button with the text "Debug" will be shown to give further information.
	-- * (Default: false)
	-- ********************************************************************************************
	ActivateDebug = false,
 
	-- ********************************************************************************************
	-- * Callback_OnMapStart
	-- * Called directly after the loading screen vanishes and works as your entry point.
	-- * Similar use to FirstMapAction/GameCallback_OnGameSart
	-- ********************************************************************************************
	Callback_OnMapStart = function()
		AddPeriodicSummer(60);
		SetupHighlandWeatherGfxSet();
		LocalMusic.UseSet = HIGHLANDMUSIC;
		Script.Load("data\\maps\\user\\EMS\\tools\\s5CommunityLib\\packer\\devLoad.lua")
		mcbPacker.Paths = {{"data/maps/user/EMS/tools/", ".lua"}}
		mcbPacker.require("s5CommunityLib/lib/UnlimitedArmySpawnGenerator")
		mcbPacker.require("s5CommunityLib/lib/UnlimitedArmy")
		TriggerFix.AllScriptsLoaded()						
		---InitPlayerColorMapping()
		Mission_InitTechnologies()	
		gvMission = {}
		gvMission.PlayerID = GUI.GetPlayerID()			
		OverrideDiplomacy()
		SetupPlayer6AI()
		SetupPlayer5AI()
		Quest1()		
		CreatePreludeBriefing()
		StartSimpleJob("OpenPrison")
		StartSimpleJob("OpenPrison1")
		StartSimpleJob("OpenPrison2")
		StartSimpleJob("OpenPrison3")
		StartSimpleJob("OpenPrison4")
		CreateWoodPile( "P1", 500000)
		CreateWoodPile( "P2", 500000)
		gv_difficulty = 1
		gv_difficulty = 2
		KasernenHACK()
		InitPlayerColorMapping()
		StartSimpleJob("EnableDario1Dead")		
		StartSimpleJob("EnableDarioDead")			
		---p1
		CreateChest(GetPosition("chest1"),  chestCallbackIron)	
		CreateChest(GetPosition("chest2"),  chestCallbackIron1)
		CreateChest(GetPosition("chest3"),  chestCallbackIron2)	
		CreateChest(GetPosition("chest4"),  chestCallbackIron3)
	    CreateChest(GetPosition("chest5"),  chestCallbackIron5)		
		CreateChest(GetPosition("chest6"),  chestCallbackIron6)
		CreateChest(GetPosition("chest7"),  chestCallbackIron7)		
		CreateChest(GetPosition("chest8"),  chestCallbackIron8)				
		CreateChest(GetPosition("chest9"),  chestCallbackGold1)
	    CreateChest(GetPosition("chest10"), chestCallbackGold2)
		CreateChest(GetPosition("chest11"), chestCallbackGold3)
	    CreateChest(GetPosition("chest12"), chestCallbackGold4)		
		CreateChest(GetPosition("chest13"), chestCallbackGold5)
	    CreateChest(GetPosition("chest14"), chestCallbackGold6)
		CreateChest(GetPosition("chest15"), chestCallbackGold7)
	    CreateChest(GetPosition("chest16"), chestCallbackGold8)		
		CreateChest(GetPosition("chest17"), chestCallbackGold9)		
		CreateChest(GetPosition("chest18"), chestCallbackGold10)
		CreateChest(GetPosition("chest19"), chestCallbackIron4)
		CreateChest(GetPosition("chest20"), chestCallbackIron9)	
		CreateChestOpener("dario")
		CreateChestOpener("Dario1")
		CreateChestOpener("Pilgrim")
		CreateChestOpener("Pilgrim1")
		StartChestQuest()
		Burgaussehen1()	
		Burgaussehen2()	
		Burgaussehen3()	
		Burgaussehen4()	
		Burgaussehen5()	
		Burgaussehen6()	
		Burgaussehen7()	
		Burgaussehen8()
		Burgaussehen9()
		Burgaussehen10()
		Burgaussehen11()
		StartSimpleJob("VictoryJob")
		MercTent1()
		MercTent2()
		
		  
		ActivateShareExploration( 1,2, true ) -- Gegenseitige Sicht zwischen Player1 und Player2
			
			
		
			  --Speere verboten---
ForbidTechnology (Technologies.T_UpgradeSpear1, 1)
ForbidTechnology (Technologies.T_UpgradeSpear1, 2)
--Speer 2 verboten--
ForbidTechnology (Technologies.T_UpgradeSpear2, 1)
ForbidTechnology (Technologies.T_UpgradeSpear2, 2)
--Speer 3 verboten--
ForbidTechnology (Technologies.T_UpgradeSpear3, 1)
ForbidTechnology (Technologies.T_UpgradeSpear3, 2)

GUITooltip_BuyMilitaryUnit_orig = GUITooltip_BuyMilitaryUnit;  
function GUITooltip_BuyMilitaryUnit(_unit,_widget,_keybind)
    GUITooltip_BuyMilitaryUnit_orig(_unit,_widget,_keybind);
    if (_unit == UpgradeCategories.LeaderPoleArm) then
            XGUIEng.SetText(gvGUI_WidgetID.TooltipBottomText,"@color:255,0,0 Kaufe einen @color:255,255,255 Krieger des Nebelvolkes")  -- Beschreibung der Einheit / Des Buttons			
        end
 end

end,
 

	-- ********************************************************************************************
	-- * Callback_OnGameStart
	-- * Called at the end of the 10 seconds delay, after the host chose the rules and started
	-- ********************************************************************************************
	Callback_OnGameStart = function()
		StartSimpleJob("AI_AliveChecker")
		StartSimpleJob("Inselaktivierung1")
		StartSimpleJob("InselBurgaktivierung1")
		StartSimpleJob("InselBurgaktivierung2")
		StartSimpleJob("InselZita1")
		StartSimpleJob("InselZita2")
		StartSimpleJob("barries")
		
		for i = 1, 5 do
			_G["createarmy"..i]()
	    end
		
	    for i = 6, 10 do
			_G["createarmy"..i]()
		end	
		
		createarmy13()
		createarmy16()
		createarmy17()
		createarmy46()	
		createarmy48()	
		createarmy118()	
		createarmy119()	
		
	Truppen()
	CreateMonch1()
	CreateNpcs()
	CreateNpcs1()
	CreateWanderer1()
	end,
 
	-- ********************************************************************************************
	-- * Callback_OnPeacetimeEnded
	-- * Called when the peacetime counter reaches zero
	-- ********************************************************************************************
	Callback_OnPeacetimeEnded = function()
		for i = 1,15 do
			MapTools.OpenPalisadeGates()
			MapTools.OpenWallGates();
		end
		AddPeriodicSummer(30*60);
		AddPeriodicRain(7*60);
		AddPeriodicWinter(10*60);
		 --danach KI
		createarmy24()	
		createarmy27()	
		createarmy28()	
		createarmy41()	
		createarmy42()
		createarmy43()
		createarmy47()
		createarmy68()
		createarmy68()
		
	    for i = 31, 38 do
			_G["createarmy"..i]()		
		end	
		
		for i = 49, 53 do
			_G["createarmy"..i]()		
		end		
		
		for i = 56, 65 do
			_G["createarmy"..i]()		
		end	
		for i = 18, 23 do
			_G["createarmy"..i]()		
		end
		for i = 114, 117 do
			_G["createarmy"..i]()		
		end
			
	end,
 
 
	-- ********************************************************************************************
	-- * Peacetime
	-- * Number of minutes the players will be unable to attack each other
	-- ********************************************************************************************
	Peacetime = 40,
  
	-- ********************************************************************************************
	-- * GameMode
	-- * GameMode is a concept of a switchable option, that the scripter can freely use
	-- *
	-- * GameModes is a table that contains the available options for the players, for example:
	-- * GameModes = {"3vs3", "2vs2", "1vs1"},
	-- *
	-- * GameMode contains the index of selected mode by default - ranging from 1 to X
	-- *
	-- * Callback_GameModeSelected
	-- * Lets the scripter make changes, according to the selected game mode.
	-- * You could give different ressources or change the map environment accordingly
	-- * _gamemode contains the index of the selected option according to the GameModes table
	-- ********************************************************************************************
	GameMode = 1,
	GameModes = {"Mittel" , "Schwer" },
	Callback_GameModeSelected = function(_gamemode)
   -- leicht
    gv_difficulty = _gamemode
    -- mittel
    -- schwer
	end,
 
 
 
	-- ********************************************************************************************
	-- * Resource Level
	-- * Determines how much ressources the players start with
	-- * 1 = Normal
	-- * See the ressources table below for configuration
	-- ********************************************************************************************
	ResourceLevel = 1,
 
	-- ********************************************************************************************
	-- * Resources
	-- * Order:
	-- * Gold, Clay, Wood, Stone, Iron, Sulfur
	-- * Rules:
	-- * 1. If no player is defined, default values are used
	-- * 2. If player 1 is defined, these ressources will be used for all other players too
	-- * 3. Use the players index to give ressources explicitly
	-- ********************************************************************************************
	Ressources =
	{
		-- * Normal default: 1k, 1.8k, 1.5k, 0.8k, 50, 50
		Normal = {
			[1] = {
				500,
				2400,
				1750,
				700,
				50,
				50,
			},
		},
	},
 
	-- ********************************************************************************************
	-- * AI Players
	-- * Player Entities that belong to an ID that is also present in the AIPlayers table won't be
	-- * removed
	-- ********************************************************************************************
	AIPlayers = {8},
 
	-- ********************************************************************************************
	-- * DisableInitCameraOnHeadquarter
	-- * Set to true if you don't want the camera to be set to the headquarter automatically
	-- * (default: false)
	-- ********************************************************************************************
	DisableInitCameraOnHeadquarter = false,
 
	-- ********************************************************************************************
	-- * DisableSetZoomFactor
	-- * If set to false, ZoomFactor will be set to 2 automatically
	-- * Set to true if nothing should be done
	-- * (default: false)
	-- ********************************************************************************************
	DisableSetZoomFactor = false,
 
	-- ********************************************************************************************
	-- * DisableStandardVictoryCondition
	-- * Set to true if you want to implement your own victory condition
	-- * Otherwise the player will lose upon losing his headquarter
	-- * (default: false)
	-- ********************************************************************************************
	DisableStandardVictoryCondition = true,
 
	-- ********************************************************************************************
	-- * Units
	-- * Various units can be allowed or forbidden
	-- * A 0 means the unit is forbidden - a higher number represents the maximum allowed level
	-- * Example: 
	-- * Sword = 0, equals Swords are forbidden
	-- * Sword = 2, equals the maximum level for swords is 2 = Upgrading once
	-- ********************************************************************************************
	Sword   = 4,
	Bow     = 4,
	PoleArm = 4,
	HeavyCavalry = 2,
	LightCavalry = 2,
	Rifle = 2,
	Thief = 0,
	Scout = 1,
	Cannon1 = 1,
	Cannon2 = 1,
	Cannon3 = 1,
	Cannon4 = 1,
 
	-- * Buildings
	Bridge = 1,
	-- * Markets
	-- * 0 = Building markets is forbidden
	-- * 1 = Building markets is allowed
	-- * greater then one = Markets are allowed and limited to the number given
	Markets = 0,
 
	-- * Trade Limit
	-- * 0 = no trade limit
	-- * greater zero = maximum amount that you can buy in one single trade 
	TradeLimit = 0,
 
	-- * TowerLevel
	-- * 0 = Towers forbidden
	-- * 1 = Watchtowers
	-- * 2 = Balistatowers
	-- * 3 = Cannontowers
	TowerLevel = 3, -- 0-3
 
	-- * TowerLimit
	-- * 0  = no tower limit
	-- * >0 = towers are limited to the number given
	TowerLimit = 0,
 
	-- * WeatherChangeLockTimer
	-- * Minutes for how long the weather can't be changed directly again after a weatherchange happened
	WeatherChangeLockTimer =  3,
 
	MakeSummer = 1,
	MakeRain   = 1,
	MakeSnow   = 1,
 
	-- * Fixes the DestrBuild bug
	AntiBug    = 1,
 
	-- * HQRush
	-- * If set to 1, Headquarters are invulernerable as long the player still has village centers
	AntiHQRush = 0,
 
	-- * If set to 1, Players can't abuse blessing and overtime in combination for unlimited work
	BlessLimit = 1,
 
	-- * if set to true, Players are not able to lose their Headquarter.
	InvulnerableHQs = false,
 
	-- * Heroes
	Dario    = 0,
	Pilgrim  = 0,
	Ari      = 0,
	Erec     = 0,
	Salim    = 0,
	Helias   = 0,
	Drake    = 0,
	Yuki     = 0,
	Kerberos = 0,
	Varg     = 0,
	Mary_de_Mortfichet = 0,
	Kala     = 0,
};


function OverrideDiplomacy() -- diplo in funktion ausgelagert
	SetHostile( 1, 6 )
	SetHostile( 2, 6 )
	SetFriendly( 1, 2 )
	SetFriendly( 2, 1 )
	end

function SetupPlayer5AI()
	local aiID = 5;
	SetPlayerName( aiID, "Bewohner" );
end	


function SetupPlayer6AI()
	local aiID = 6;
	SetupPlayerAi( aiID, {6}); -- p8 hat nix anderes außer scriptgesteuerte truppen, deswegen kann wird der rest nicht benötigt
	SetupPlayerAi( aiID, { constructing = true } );
	SetPlayerName( aiID, "Birnheim" );
end	


function VictoryJob() 
	if IsDestroyed("Festung_MitteFront") and IsDead("zitarechtsOben") and IsDead("zitaOben") and IsDead("ZitalinksOben") then
		if Logic.PlayerGetGameState(1)==1 then 
			Logic.PlayerSetGameStateToWon(1)
		end
		if Logic.PlayerGetGameState(2)==1 then
			Logic.PlayerSetGameStateToWon(2)
		end
		return true;
	end
end
 
 function VictoryPlayers()
  for p=1,2 do
    if Logic.PlayerGetGameState(p) == 1 then
        Logic.PlayerSetGameStateToVictory(p)
    end
  end
  Trigger.DisableTriggerSystem(1)
end


-- Truppen

function Truppen()

AI.Entity_CreateFormation(1, Entities.PU_LeaderBow3, nil, 8, GetPosition("Truppe1").X, GetPosition("Truppe1").Y, 0, 1, 2,3)
AI.Entity_CreateFormation(1, Entities.PU_LeaderSword4, nil, 8, GetPosition("Truppe1").X, GetPosition("Truppe1").Y, 0, 1, 2,3)
AI.Entity_CreateFormation(2, Entities.PU_LeaderBow3, nil, 8, GetPosition("Truppe2").X, GetPosition("Truppe2").Y, 0, 1, 2,3)
AI.Entity_CreateFormation(2, Entities.PU_LeaderSword4, nil, 8, GetPosition("Truppe2").X, GetPosition("Truppe2").Y, 0, 1, 2,3)
end


-- Diese Funktion öffnet das Gefängnis, wenn der Turm von player2 zerstört ist

function OpenPrison()
  if IsDead("Zeltu") then
        DestroyEntity (GetID("palisade_door")) 
        return true
    end
end
 
 
 function OpenPrison1()
  if IsDead("Zelt2") then
        DestroyEntity (GetID("zaun1")) 
        return true
    end
end

 function OpenPrison2()
  if IsDead("Turm_A") and IsDead("Turm_B") then
        DestroyEntity (GetID("Zaun3")) 
        return true
    end
end

 function OpenPrison3()
  if IsDead("Turm_A") and IsDead("Turm_B") then
        DestroyEntity (GetID("Zaun4")) 
        return true
    end
end


 function OpenPrison4()
  if IsDead("Turm_A") and IsDead("Turm_B") then
        DestroyEntity (GetID("Zaun5")) 
        return true
    end
end
 ---------------------------------

function EnableDarioDead()
    if IsDead("dario") then
        Defeat()
        return true
    end
end

function DefeatIfHQDead()
    if IsDead("hq") then
        Defeat()
        return 
    end
end

function EnableDarioDefeat()
    DarioDefeatedJob = StartSimpleJob("DefeatIfDarioDead")
end
function EnableHQDefeat()
    EndJob(DarioDefeatedJob)
    StartSimpleJob("DefeatIfHQDead")
end

-------------------------------

function EnableDario1Dead()
    if IsDead("Dario1") then
        Defeat()
        return true
    end
end

function DefeatIfHQ1Dead()
    if IsDead("hq1") then
        Defeat()
        return 
    end
end

function EnableDario1Defeat()
    Dario1DefeatedJob = StartSimpleJob("EnableDario1Defeat")
end
function EnableHQ1Defeat()
    EndJob(Dario1DefeatedJob)
    StartSimpleJob("DefeatIfHQ1Dead")
end

------------
--- Kaserne 
------------

function KasernenHACK()
GUIAction_BuyMilitaryUnit_Orig = GUIAction_BuyMilitaryUnit
	GUIAction_BuyMilitaryUnit = function(_a)
		if _a == UpgradeCategories.LeaderPoleArm then
			_a = UpgradeCategories.Evil_LeaderBearman
		end
		GUIAction_BuyMilitaryUnit_Orig(_a)
	end
end

function InitPlayerColorMapping()
	Display.SetPlayerColorMapping(6,10)
	XGUIEng.TransferMaterials( "Hero12_PoisonRange", "Buy_LeaderSpear" )
end

--------------------------------

--  for spieler 1

-- Briefing "Prelude"
function CreatePreludeBriefing()
	PreludeBriefing = {}
	PreludeBriefing.finished = PreludeBriefingFinished
	page = 0
	--	page #1
	page = page + 1
	PreludeBriefing[page] 				  	= 	{}
	PreludeBriefing[page].title			  	= 	"Pilgrim"
	PreludeBriefing[page].text			  	=	"em dario, wo sind wir  hier gelanden?"
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	PreludeBriefingShowStartPos			  	=	PreludeBriefing[page]
	--	page #2
	page = page + 1
	PreludeBriefing[page] 				  	= 	{}
	PreludeBriefing[page].title			  	= 	"Dario"
	PreludeBriefing[page].text			  	=	"Das soll angeblich der Ort sein wo die Große Festung von Birnheim sein soll."
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	PreludeBriefingShowStartPos			  	=	PreludeBriefing[page]
	--	page #3
	page = page + 1
	PreludeBriefing[page] 				  	= 	{}
	PreludeBriefing[page].title			  	= 	"Pilgrim"
	PreludeBriefing[page].text			  	=	"Dann lass uns schnell beeilen damit wir endlich Frieden finden und nicht diesen hohen Stress haben."
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	PreludeBriefingShowStartPos			  	=	PreludeBriefing[page]
	-- page #4
	page = page + 1
	PreludeBriefing[page] 				  	= 	{}
	PreludeBriefing[page].title			  	= 	"Dario"
	PreludeBriefing[page].text			  	=	"Das klingt aufjedenfall nach einen guten Plan legen wir los."
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	PreludeBriefingShowStartPos			  	=	PreludeBriefing[page]
	--	page #5
	page = page + 1
	PreludeBriefing[page] 			   		= 	{}
	PreludeBriefing[page].title				= 	"Dario"
	PreludeBriefing[page].text			  	=	"Da fehlt mir noch ein, Wir sollten mal schauen wo wir eine schöne Burg finden, weil unsere Arbeiter sind im fußmarsch alle leider Gestorben hierher und haben nur noch 2 unseren Stärksten Truppen hier."
	PreludeBriefing[page].position 			= 	GetPosition("StartPos")
	PreludeBriefingShowlicht1			  	=	PreludeBriefing[page]
	--	page #6
	page = page + 1
	PreludeBriefing[page] 					= 	{}
	PreludeBriefing[page].title				= 	"Pilgrim"
	PreludeBriefing[page].text				=	"Wir sollten aber auf die Patrollien Truppen aufpassen die hier im land rumlaufen tuen."
	PreludeBriefing[page].position 			= 	GetPosition("StartPos")
	PreludeBriefingShowBurg1			  	=	PreludeBriefing[page]
	-- page #7
	page = page + 1
	PreludeBriefing[page] 				  	= 	{}
	PreludeBriefing[page].title			  	= 	"Dario"
	PreludeBriefing[page].text			  	=	"Da hast vollkommen recht Pilgrim, lass und mal los Maschieren."
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	PreludeBriefingShowStartPos			  	=	PreludeBriefing[page]
	-- page #8
	page = page + 1
	PreludeBriefing[page] 				  	= 	{}
	PreludeBriefing[page].title			  	= 	"Dario"
	PreludeBriefing[page].text			  	=	"Achso nur so vorweg irgentwo gabs auch großse schätze von den Inseln, da sollten wir vllt auch mal nachschauen."
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	PreludeBriefingShowStartPos			  	=	PreludeBriefing[page]
	--	page #9
	page = page + 1
	PreludeBriefing[page] 				    = 	{}
	PreludeBriefing[page].title			  	= 	"Maxi"
	PreludeBriefing[page].text			    =	"Ich wünsche Euch viel Spaß bei meiner Karte!"
	PreludeBriefing[page].position 		  	= 	GetPosition("StartPos")
	StartBriefing( Umlaute(PreludeBriefing) )
end

---------------------------------------------------------------------------------------------
-- BriefingFinished "Prelude"
function PreludeBriefingFinished()
	ResolveBriefing(PreludeBriefingShowBurg1)
end


-- Briefing "Prelude1"
function CreatePrelude1Briefing()
	Prelude1Briefing = {}
	Prelude1Briefing.finished = Prelude1BriefingFinished
	page = 0
	--	page #1
	page = page + 1
	Prelude1Briefing[page] 				  	= 	{}
	Prelude1Briefing[page].title			  	= 	"Pilgrim"
	Prelude1Briefing[page].text			  	=	"em dario wo sind wir  hier gelanden?"
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	Prelude1BriefingShowStartPos			  	=	Prelude1Briefing[page]
	--	page #2
	page = page + 1
	Prelude1Briefing[page] 				  	= 	{}
	Prelude1Briefing[page].title			  	= 	"Dario"
	Prelude1Briefing[page].text			  	=	"das soll angeblich der Ort sein wo die Große Festung von Birnheim sein sollte."
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	Prelude1BriefingShowStartPos			  	=	Prelude1Briefing[page]
	--	page #3
	page = page + 1
	Prelude1Briefing[page] 				  	= 	{}
	Prelude1Briefing[page].title			  	= 	"Pilgrim"
	Prelude1Briefing[page].text			  	=	"Dann lass uns schnell beeilen damit wir endlich Frieden finden und nicht diesen hohen Stress haben."
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	Prelude1BriefingShowStartPos			  	=	Prelude1Briefing[page]
	-- page #4
	page = page + 1
	Prelude1Briefing[page] 				  	= 	{}
	Prelude1Briefing[page].title			  	= 	"Dario"
	Prelude1Briefing[page].text			  	=	"das klignt aufjedenfall nach guten Plan legen wir los."
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	Prelude1BriefingShowStartPos			  	=	Prelude1Briefing[page]
	--	page #5
	page = page + 1
	Prelude1Briefing[page].title				= 	"Dario"
	Prelude1Briefing[page].text			  	=	"Da fehlt mir noch ein, Wir sollten mal schauen wo wir eine schöne Burg finden, weil unsere Arbeiter sind im fußmarsch alle leider Gestorben hierher und haben nur noch 2 unseren Stärksten Truppen hier."
	Prelude1Briefing[page].position 			= 	GetPosition("StartPos")
	Prelude1BriefingShowlicht1			  	=	Prelude1Briefing[page]
	--	page #6
	page = page + 1
	Prelude1Briefing[page] 					= 	{}
	Prelude1Briefing[page].title				= 	"Pilgrim"
	Prelude1Briefing[page].text				=	"wir sollten aber auf die Patrollien Truppen aufpassen die hier im land rumlaufen tuen."
	Prelude1Briefing[page].position 			= 	GetPosition("StartPos")
	Prelude1BriefingShowBurg1			  	=	Prelude1Briefing[page]
	-- page #7
	page = page + 1
	Prelude1Briefing[page] 				  	= 	{}
	Prelude1Briefing[page].title			  	= 	"Dario"
	Prelude1Briefing[page].text			  	=	"Da hast vollkommen recht Pilgrim, lass und mal los Maschieren."
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	Prelude1BriefingShowStartPos			  	=	Prelude1Briefing[page]
	-- page #8
	page = page + 1
	Prelude1Briefing[page] 				  	= 	{}
	Prelude1Briefing[page].title			  	= 	"Dario"
	Prelude1Briefing[page].text			  	=	"Achso nur so vorweg irgentwo gabs auch großse schätze von den Inseln, da sollten wir vllt auch mal nachschauen."
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	Prelude1BriefingShowStartPos			  	=	Prelude1Briefing[page]
	--	page #9
	page = page + 1
	Prelude1Briefing[page] 				    = 	{}
	Prelude1Briefing[page].title			  	= 	"Maxi"
	Prelude1Briefing[page].text			    =	"Ich wünsche Euch viel Spaß bei meiner Karte!"
	Prelude1Briefing[page].position 		  	= 	GetPosition("StartPos")
	StartBriefing( Umlaute(Prelude1Briefing) )
end

---------------------------------------------------------------------------------------------
-- BriefingFinished "Prelude1"
function Prelude1BriefingFinished()
	ResolveBriefing(Prelude1BriefingShowBurg1)
end


---------------------------------------


function CreateNpcs()
    HermitBriefing                         =   {}
    HermitBriefing.restoreCamera           =   true
    HermitBriefing.finished                =  Hermitfinished

    page = 0

    page = page + 1
    HermitBriefing[page]               =   {}

    HermitBriefing[page].title         =   "Landsman"
    HermitBriefing[page].text          =   "Danke euch Edler Herr für die Rettung und meiner Leibeigenen."
    HermitBriefing[page].position      =   GetPosition("Hermit")
    HermitBriefing[page].dialogCamera  =   true

    page = page + 1
    HermitBriefing[page]               =   {}
    HermitBriefing[page].title         =   "Landsman"
    HermitBriefing[page].text          =   "Wir stehen unter euren Schutz und geben euch diese Einzigartige Hauptburg."
    HermitBriefing[page].explore       =   1200
    HermitBriefing[page].position      =   GetPosition("headquarter")
    HermitBriefing[page].restoreCamera  =   true
	
	page = page + 1
    HermitBriefing[page]               =   {}
    HermitBriefing[page].title         =   "Landsman"
    HermitBriefing[page].text          =   "Aber aufpassen im Gebiet gibst noch mehrere Soldaten die Wache halten tun."
	HermitBriefing[page].explore       =   1200
    HermitBriefing[page].position      =   GetPosition("hq")
    HermitBriefing[page].restoreCamera  =   true

    HermitKas = HermitBriefing[page]
    -- Setup table for NPC
    Her                     =   {}
    Her.name                =   "Hermit"
    Her.briefing            =   HermitBriefing
    -- Create the NPC
    CreateNPC(Her)
end

-- BriefingFinished "Hermit"
function Hermitfinished()
	ChangeLeibi()
	ResolveBriefing (HermitKas)
end

------

function CreateNpcs1()
    Land1Briefing                         =   {}
    Land1Briefing.restoreCamera           =   true
    Land1Briefing.finished                =  Land1finished

    page = 0

    page = page + 1
    Land1Briefing[page]               =   {}

    Land1Briefing[page].title         =   "Feldmann"
    Land1Briefing[page].text          =   "Danke euch Edler Herr für die Rettung und meiner Leibeigenen."
    Land1Briefing[page].position      =   GetPosition("Land1")
    Land1Briefing[page].dialogCamera  =   true
	
	page = page + 1
    Land1Briefing[page]               =   {}
    Land1Briefing[page].title         =   "Feldmann"
    Land1Briefing[page].text          =   "Wir stehen unter euren Schutz und geben euch diese Einzigartige Hauptburg."
    Land1Briefing[page].explore       =   1200
    Land1Briefing[page].position      =   GetPosition("headquarter1")
    Land1Briefing[page].restoreCamera  =   true

    page = page + 1
	Land1Briefing[page]               =   {}
    Land1Briefing[page].title         =   "Feldman"
    Land1Briefing[page].text          =   "Aber aufpassen im Gebiet gibst noch mehrere Soldaten die Wache halten tun."
    Land1Briefing[page].explore       =   1200
    Land1Briefing[page].position      =   GetPosition("hq1")
    Land1Briefing[page].restoreCamera  =   true

    Land1man = HermitBriefing[page]
    -- Setup table for NPC
    Her                     =   {}
    Her.name                =   "Land1"
    Her.briefing            =    Land1Briefing
    -- Create the NPC
    CreateNPC(Her)
end

-- BriefingFinished "Land1"
function Land1finished()
	ChangeLeibis()
	ResolveBriefing (Land1man)
end


----------------------- Monch

function CreateMonch1()
	MonchBriefing                         =   {}
    MonchBriefing.restoreCamera           =   true
    MonchBriefing.finished                =  Monchfinished

    page = 0

    page = page + 1
    MonchBriefing[page]               =   {}
    MonchBriefing[page].title         =   "Mönch"
    MonchBriefing[page].text          =   "Ui Edler Herr was Treibt dich den zu unseren grauenvollen Ort?."
    MonchBriefing[page].position      =   GetPosition("Monch")
    MonchBriefing[page].dialogCamera  =   true

    page = page + 1
    MonchBriefing[page]               =   {}
    MonchBriefing[page].title         =   "Dario"
    MonchBriefing[page].text          =   "kann man bei euch soldaten hohlen bzw wollt ihr uns mit  soldaten helfen."
    MonchBriefing[page].position      =   GetPosition("Monch")
    MonchBriefing[page].dialogCamera  =   true

    page = page + 1
    MonchBriefing[page]               =   {}
    MonchBriefing[page].title         =   "Mönch"
    MonchBriefing[page].text          =   "Wir koennen euch Truppen geben. aber uns fehlen die Talerm, um ne Schlagkreaftige Armme aufbauen zu koennen."
    MonchBriefing[page].explore       =   1200
    MonchBriefing[page].position      =   GetPosition("Monch")
    MonchBriefing[page].restoreCamera  =   true
	
	page = page + 1
    MonchBriefing[page]               =   {}
    MonchBriefing[page].title         =   "Dario"
    MonchBriefing[page].text          =   "dabei koennen wir euch helfen bei den Talern, wir nehmen jede Hilfe gerne an wenns geht."
    MonchBriefing[page].position      =   GetPosition("Monch")
    MonchBriefing[page].dialogCamera  =   true
	
    MonchKas = MonchBriefing[page]
    -- Setup table for NPC
    Her                     =   {}
    Her.name                =   "Monch"
    Her.briefing            =   MonchBriefing
    -- Create the NPC
    CreateNPC(Her)
end

-- BriefingFinished "Monch"
function Monchfinished()
	CreateMonch2()
	ResolveBriefing (MonchKas)
end

----------------------- Monch 2

function CreateMonch2()
	MonchZBriefing                         =   {}
    MonchZBriefing.restoreCamera           =   true
    MonchZBriefing.finished                =  MonchZfinished

    page = 0
	
	
    page = page + 1
    MonchZBriefing[page]               =   {}
    MonchZBriefing[page].title         =   "Mönch"
    MonchZBriefing[page].text          =   "Rettet unseren Kollege von der Abtei, die Banditen haben ihn."
    MonchZBriefing[page].position      =   GetPosition("Monch")
	MonchZBriefingShowMonch		  	=	PreludeBriefing[page]

    page = page + 1
    MonchZBriefing[page]               =   {}
    MonchZBriefing[page].title         =   "Mönch"
    MonchZBriefing[page].text          =   "Rettet unseren Kollege von der Abtei, die Banditen haben ihn."
    MonchZBriefing[page].position      =   GetPosition("Monchi")
	MonchZBriefingShowMonchi			  	=	PreludeBriefing[page]
	
	page = page + 1
    MonchZBriefing[page]               =   {}
    MonchZBriefing[page].title         =   "ERZÄHLER"
    MonchZBriefing[page].text          =   "Vernichtet die BanditenTuerme."
    MonchZBriefing[page].position      =   GetPosition("Monch")
	MonchZBriefingShowMonch		  	=	PreludeBriefing[page]
		
    MonchZKas = MonchZBriefing[page]
    -- Setup table for NPC
    Her                     =   {}
    Her.name                =   "Monch"
    Her.briefing            =   MonchZBriefing
    -- Create the NPC
    CreateNPC(Her)
end

-- BriefingFinished "MonchZ"
function MonchZfinished()
	--for i = 2, 5 do
			--_G["createarmy"..i]()
		--end
	createarmy1()
	CreateMonch3()
	barries1()
	ResolveBriefing (MonchZKas)
end



----------------------- Monchi 3

function CreateMonch3()
	Monch_1Briefing                         =   {}
    Monch_1Briefing.restoreCamera           =   true
    Monch_1Briefing.finished                =  Monch_1finished

    page = 0
	
	
    page = page + 1
    Monch_1Briefing[page]               =   {}
    Monch_1Briefing[page].title         =   "Gustav"
    Monch_1Briefing[page].text          =   "Gott Herr sei Dank für die Rettung."
    Monch_1Briefing[page].position      =   GetPosition("Monchi")
	PreludeBriefingShowMonchi			  	=	PreludeBriefing[page]

    page = page + 1
    Monch_1Briefing[page]               =   {}
    Monch_1Briefing[page].title         =   "Gustav"
    Monch_1Briefing[page].text          =   "Wir werden euch mit Truppen helfen."
    Monch_1Briefing[page].position      =   GetPosition("Kirche_Brief")
	Monch_1BriefingShowKirche_Brief		  	=	PreludeBriefing[page]
	
	page = page + 1
    Monch_1Briefing[page]               =   {}
    Monch_1Briefing[page].title         =   "Gustav"
    Monch_1Briefing[page].text          =   "Als Tipp in den Bergen sind Große Steineminen damit koennt ihr unsere die Kadredrahle wieder aufbauen, dann können wir euch noch besser mithelfen."
    Monch_1Briefing[page].position      =   GetPosition("steinmine")
	Monch_1BriefingShowsteinmine	  	=	PreludeBriefing[page]
	
    page = page + 1
    Monch_1Briefing[page]               =   {}
    Monch_1Briefing[page].title         =   "Gustav"
    Monch_1Briefing[page].text          =   "Sowohl auch diese Mine."
    Monch_1Briefing[page].position      =   GetPosition("steinmine1")
	Monch_1BriefingShowsteinmine1	  	=	PreludeBriefing[page]
		
	Monch_1Kas = Monch_1Briefing[page]
    -- Setup table for NPC
    Her                     =   {}
    Her.name                =   "Monchi"
    Her.briefing            =   Monch_1Briefing
    -- Create the NPC
    CreateNPC(Her)
end

-- BriefingFinished "MonchZ"
function Monch_1finished()
	SetHostile( 5, 6)
	SetHostile( 6, 5)
--- Tribute	
	for i=1,2 do
    function Kirche()
        ReplaceEntity("Kirche_1", Entities.PB_Monastery3)
		createarmy113()
    end
    local tribute =  {};
    tribute.pId = i;
    tribute.text = "Zahle 10000 steine für die Cathedral."
    tribute.cost = { Stone = 10000 };
    tribute.Callback = Kirche;
    AddTribute( tribute );
	end
	ResolveBriefing (Monch_1Kas)
end


----------------------- Wanderer 1

function CreateWanderer1()
	WandererBriefing                         =   {}
    WandererBriefing.restoreCamera           =   true
    WandererBriefing.finished                =  Wandererfinished

    page = 0
	
	
    page = page + 1
    WandererBriefing[page]               =   {}
    WandererBriefing[page].title         =   "Wanderer"
    WandererBriefing[page].text          =   "Hallo Fremder, was Treibt euch den hier Her?"
    WandererBriefing[page].position      =   GetPosition("Wanderer10")
	PreludeBriefingShowWanderer10			  	=	PreludeBriefing[page]

    page = page + 1
    WandererBriefing[page]               =   {}
    WandererBriefing[page].title         =   "Dario"
    WandererBriefing[page].text          =   "Hallo, wir wollten mal schauen ob hier noch irgentwo Patrollien Truppen sind."
    WandererBriefing[page].position      =   GetPosition("Wanderer10")
	PreludeBriefingShowWanderer10			  	=	PreludeBriefing[page]

    page = page + 1
    WandererBriefing[page]               =   {}
    WandererBriefing[page].title         =   "Wanderer"
    WandererBriefing[page].text          =   "Okay, Frag mal den Priester dort, aber Achtung der wird irgentwie Gefangen gehalten von den Truppen von Birnheim."
    WandererBriefing[page].position      =   GetPosition("dz_mitte")
	WandererBriefingShowdz_mitte		  	=	PreludeBriefing[page]
	
    page = page + 1
    WandererBriefing[page]               =   {}
    WandererBriefing[page].title         =   "Dario"
    WandererBriefing[page].text          =   "Danke für die Info, Wir werden Nachschauen was dort los ist."
    WandererBriefing[page].position      =   GetPosition("dz_mitte")
	WandererBriefingShowdz_mitte		  	=	PreludeBriefing[page]
	
	 page = page + 1
    WandererBriefing[page]               =   {}
    WandererBriefing[page].title         =   "Mentor"
    WandererBriefing[page].text          =   "Befreit den Priester Von den Truppen von Birnheim."
    WandererBriefing[page].position      =   GetPosition("dz_mitte")
	WandererBriefingShowdz_mitte		  	=	PreludeBriefing[page]
	
	WandererKas = WandererBriefing[page]
    -- Setup table for NPC
    Her                     =   {}
    Her.name                =   "Wanderer10"
    Her.briefing            =   WandererBriefing
    -- Create the NPC
    CreateNPC(Her)
end

-- BriefingFinished "MonchZ"
function Wandererfinished()
	ResolveBriefing (WandererKas)
end


--- Quest1

function Quest1()	
Logic.AddQuest(1, 1, MAINQUEST_OPEN, "Der Sieg","Man dachte der Krieg war vorbei und Birnheim war unter Asche bedeckt, aber alle haben sich gewundert wo es ins obere land ging, das waren Nicht die banditen, die Bewohner in Angst und Schrecken gezogen haben. Vernichtet Birnheim komplett damit endlich Frieden im Lande Herrschen tut, Sucht eine Burg, baut schnell eine Siedlung auf und haltet auf eure Burg immer ein Auge", 1)  
--
Logic.AddQuest(2, 2, MAINQUEST_OPEN, "Der Sieg","Man dachte der Krieg war vorbei und Birnheim war unter Asche bedeckt, aber alle haben sich gewundert wo es ins obere land ging, das waren Nicht die banditen, die Bewohner in Angst und Schrecken gezogen haben. Vernichtet Birnheim komplett damit endlich Frieden im Lande Herrschen tut, Sucht eine Burg, baut schnell eine Siedlung auf und haltet auf eure Burg immer ein Auge", 1)   
--
end


function MercTent1()
   local mercenaryId = GetEntityId("MercTent100")
  	Logic.AddMercenaryOffer(mercenaryId, Entities.PU_LeaderBow3, 5, ResourceType.Gold, 200, ResourceType.Iron, 200);
    Logic.AddMercenaryOffer(mercenaryId, Entities.PU_LeaderSword3, 5, ResourceType.Gold, 200, ResourceType.Iron, 200);
end	

function MercTent2()
   local mercenaryId = GetEntityId("MercTent101")
  	Logic.AddMercenaryOffer(mercenaryId, Entities.PU_LeaderBow3, 5, ResourceType.Gold, 200, ResourceType.Iron, 200);
    Logic.AddMercenaryOffer(mercenaryId, Entities.PU_LeaderSword3, 5, ResourceType.Gold, 200, ResourceType.Iron, 200);
end	

function Burgaussehen1()
 local burgid = GetEntityId("Turm_p5")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Abbey03)
end

function Burgaussehen2()
 local burgid = GetEntityId("Turm_B")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen3()
 local burgid = GetEntityId("Turm2")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen4()
 local burgid = GetEntityId("Turm_A")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen5()
 local burgid = GetEntityId("Turm1")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen6()
 local burgid = GetEntityId("Turm_Mitte")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen7()
 local burgid = GetEntityId("zitaOben")
   Logic.SetModelAndAnimSet(burgid, Models.CB_DarkCastle)
end

function Burgaussehen8()
 local burgid = GetEntityId("Feuer")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen9()
 local burgid = GetEntityId("Feuer1")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen10()
 local burgid = GetEntityId("H700")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function Burgaussehen11()
 local burgid = GetEntityId("H800")
   Logic.SetModelAndAnimSet(burgid, Models.CB_Bastille1)
end

function AI_AliveChecker()
	if IsDead("Feuer1") and IsDead("Feuer") then
		for i = 24, 27 do
			DestroyEntity("SnowBarrier"..i)
		end
		--
		for i = 11, 12 do
			_G["createarmy"..i]()
		end
		for i = 14, 15 do
			_G["createarmy"..i]()
		end
	return true
	end
end	

---- Insel unten wave

function Inselaktivierung1()
	if IsDead("Feuer") then
		--
		for i = 25, 26 do
			_G["createarmy"..i]()
		end
	return true
	end
end	

---- Inse2 rechts wave

function Inselaktivierung1()
	if IsDead("Feuer1") then
		--
		for i = 29, 30 do
			_G["createarmy"..i]()
		end
	return true
	end
end	

---- Insel Burg 1 links wave

function InselBurgaktivierung1()
	if IsDead("Feuer") and IsDead ("Insel_Turm1") then
		--
		for i = 39, 40 do
			_G["createarmy"..i]()
		end
	return true
	end
end	

---- Insel Burg 1 rechts wave

function InselBurgaktivierung2()
	if IsDead("Feuer1") and IsDead ("Inse2_Turm2") then
		--
		for i = 44, 45 do
			_G["createarmy"..i]()
		end
	return true
	end
end	

---- Insel Zita links wave

function InselZita1()
	if IsDead("Insel_Turm1") and IsDead ("DerPosten1") then
		--
		for i = 54, 55 do
			_G["createarmy"..i]()
		end
	return true
	end
end	

function InselZita2()
	if IsDead("Inse2_Turm2") and IsDead ("DerPosten2") then
		--
		for i = 66, 67 do
			_G["createarmy"..i]()
		end
	return true
	end
end	



--- snowbarries  
function barries()
	if IsDead("Insel_Turm1") and IsDead("Inse2_Turm2") and IsDead("Ruine_2") and IsDead("Ruine_1") and IsDead("DerPosten1") and IsDead("DerPosten2") then
		for i = 1, 21 do
			DestroyEntity("SnowBarrier"..i)
		end
		for i = 70, 85 do
			_G["createarmy"..i]()		
		end
		for i = 86, 112 do
			_G["createarmy"..i]()		
		end
		return true
	end
end	

--- snowbarries  
function barries1()
	if IsDead("Turm_Mitte") then
		for i = 22, 23 do
			DestroyEntity("SnowBarrier"..i)
		end
		return true
	end
end	

function createarmy1()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 4 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA1 = UnlimitedArmy:New {
        Player             = 5,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA1:AddCommandMove(GetPosition("Weg2"), true)
    UA1:AddCommandWaitForIdle(true)	
    UA1:AddCommandMove(GetPosition("Weg1"), true)
    UA1:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA1, {
        Position=GetPosition("Kirche_1_p5"),
		Generator = "Turm_p5", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua1)
    for id in ua1:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy2()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA2 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA2:AddCommandMove(GetPosition("Burg_2"), true)
    UA2:AddCommandWaitForIdle(true)	
    UA2:AddCommandMove(GetPosition("Burg_1"), true)
    UA2:AddCommandWaitForIdle(true)	
	UA2:AddCommandMove(GetPosition("Turm_1_Armee1"), true)
    UA2:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA2, {
        Position=GetPosition("Turm_1_Armee1"),
		Generator = "Turm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua2)
    for id in ua2:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy3()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA3 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA3:AddCommandMove(GetPosition("Kirche_1_p5"), true)
    UA3:AddCommandWaitForIdle(true)	
	UA3:AddCommandMove(GetPosition("Turm_1_Armee1"), true)
    UA3:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA3, {
        Position=GetPosition("Turm_1_Armee1"),
		Generator = "Turm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua3)
    for id in ua3:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy4()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA4 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA4:AddCommandMove(GetPosition("Kirche_1_p5"), true)
    UA4:AddCommandWaitForIdle(true)	
	UA4:AddCommandMove(GetPosition("Turm_2_Armee1"), true)
    UA4:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA4, {
        Position=GetPosition("Turm_2_Armee1"),
		Generator = "Turm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua4)
    for id in ua4:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy5()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA5 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA5:AddCommandMove(GetPosition("Burg_1"), true)
    UA5:AddCommandWaitForIdle(true)	
	UA5:AddCommandMove(GetPosition("Burg_2"), true)
    UA5:AddCommandWaitForIdle(true)	
	UA5:AddCommandMove(GetPosition("Turm_2_Armee1"), true)
    UA5:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA5, {
        Position=GetPosition("Turm_2_Armee1"),
		Generator = "Turm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua5)
    for id in ua5:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Anfang Unten bei der kirche
-------------
function createarmy6()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end
    UA6 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA6:AddCommandMove(GetPosition("Burg_1"), true)
    UA6:AddCommandWaitForIdle(true)	
	UA6:AddCommandMove(GetPosition("Burg_2"), true)
    UA6:AddCommandWaitForIdle(true)	
	UA6:AddCommandMove(GetPosition("Turm_B_Armee1"), true)
    UA6:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA6, {
        Position=GetPosition("Turm_B_Armee1"),
		Generator = "Turm_B", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua6)
    for id in ua6:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

----

function createarmy7()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA7 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA7:AddCommandMove(GetPosition("Burg_2"), true)
    UA7:AddCommandWaitForIdle(true)	
	UA7:AddCommandMove(GetPosition("Burg_1"), true)
    UA7:AddCommandWaitForIdle(true)	
	UA7:AddCommandMove(GetPosition("Turm_A_Armee1"), true)
    UA7:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA7, {
        Position=GetPosition("Turm_A_Armee1"),
		Generator = "Turm_A", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua7)
    for id in ua7:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---  turm mitte

function createarmy8()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA8 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA8:AddCommandMove(GetPosition("Turm_Mitte_Weg1"), true)
    UA8:AddCommandWaitForIdle(true)	
    UA8:AddCommandMove(GetPosition("Burg_2"), true)
    UA8:AddCommandWaitForIdle(true)	
	UA8:AddCommandMove(GetPosition("Burg_1"), true)
    UA8:AddCommandWaitForIdle(true)	
	UA8:AddCommandMove(GetPosition("Turm_Mitte_Armee1"), true)
    UA8:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA8, {
        Position=GetPosition("Turm_Mitte_Armee1"),
		Generator = "Turm_Mitte", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua8)
    for id in ua8:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy9()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA9 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA9:AddCommandMove(GetPosition("Burg_1"), true)
    UA9:AddCommandWaitForIdle(true)	
	UA9:AddCommandMove(GetPosition("Zeltu_1"), true)
    UA9:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA9, {
        Position=GetPosition("Zeltu_1"),
		Generator = "Zeltu", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua9)
    for id in ua9:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy10()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA10 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA10:AddCommandMove(GetPosition("Burg_2"), true)
    UA10:AddCommandWaitForIdle(true)	
	UA10:AddCommandMove(GetPosition("Zelt_1"), true)
    UA10:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA10, {
        Position=GetPosition("Zelt_1"),
		Generator = "Zelt2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua10)
    for id in ua10:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- Ruine links

function createarmy11()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA11 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA11:AddCommandMove(GetPosition("Burg_1"), true)
    UA11:AddCommandWaitForIdle(true)	
    UA11:AddCommandMove(GetPosition("Burg_2"), true)
    UA11:AddCommandWaitForIdle(true)	
	UA11:AddCommandMove(GetPosition("Ruine_1_Attack"), true)
    UA11:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA11, {
        Position=GetPosition("Ruine_1_Attack"),
		Generator = "Ruine_1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=2, Looped=true},
			{LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=2, Looped=true},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua11)
    for id in ua11:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy12()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA12 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA12:AddCommandMove(GetPosition("Burg_1"), true)
    UA12:AddCommandWaitForIdle(true)	
    UA12:AddCommandMove(GetPosition("Burg_2"), true)
    UA12:AddCommandWaitForIdle(true)	
	UA12:AddCommandMove(GetPosition("Ruine_1_Attack"), true)
    UA12:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA12, {
        Position=GetPosition("Ruine_1_Attack"),
		Generator = "Ruine_1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua12)
    for id in ua12:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- Snow 1

function createarmy13()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA13 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA13:AddCommandMove(GetPosition("Burg_1"), true)
    UA13:AddCommandWaitForIdle(true)	
    UA13:AddCommandMove(GetPosition("Burg_2"), true)
    UA13:AddCommandWaitForIdle(true)	
	UA13:AddCommandMove(GetPosition("Feuer_1_Attack"), true)
    UA13:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA13, {
        Position=GetPosition("Feuer_1_Attack"),
		Generator = "Feuer", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua13)
    for id in ua13:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- oben rechts 

function createarmy14()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA14 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA14:AddCommandMove(GetPosition("Burg_2"), true)
    UA14:AddCommandWaitForIdle(true)	
    UA14:AddCommandMove(GetPosition("Burg_1"), true)
    UA14:AddCommandWaitForIdle(true)	
	UA14:AddCommandMove(GetPosition("Ruine_2_Attack"), true)
    UA14:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA14, {
        Position=GetPosition("Ruine_2_Attack"),
		Generator = "Ruine_2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=2, Looped=true},
			{LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=2, Looped=true},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua14)
    for id in ua14:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy15()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA15 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA15:AddCommandMove(GetPosition("Burg_2"), true)
    UA15:AddCommandWaitForIdle(true)	
    UA15:AddCommandMove(GetPosition("Burg_1"), true)
    UA15:AddCommandWaitForIdle(true)	
	UA15:AddCommandMove(GetPosition("Ruine_2_Attack"), true)
    UA15:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA15, {
        Position=GetPosition("Ruine_2_Attack"),
		Generator = "Ruine_2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua15)
    for id in ua15:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- Snow 2

function createarmy16()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6
	end	
    UA16 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA16:AddCommandMove(GetPosition("Burg_2"), true)
    UA16:AddCommandWaitForIdle(true)	
    UA16:AddCommandMove(GetPosition("Burg_1"), true)
    UA16:AddCommandWaitForIdle(true)	
	UA16:AddCommandMove(GetPosition("Feuer_2_Attack"), true)
    UA16:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA16, {
        Position=GetPosition("Feuer_2_Attack"),
		Generator = "Feuer1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=6,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua16)
    for id in ua16:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


--- Turm zwischen spielerbasis

function createarmy17()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4
	end		
    UA17 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA17:AddCommandMove(GetPosition("Starposi"), true)
    UA17:AddCommandWaitForIdle(true)		
	UA17:AddCommandMove(GetPosition("Spieler_Mitte_Attack1"), true)
    UA17:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA17, {
        Position=GetPosition("Spieler_Mitte_Attack1"),
		Generator = "Spieler_Mitte_Attack", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderPoleArm1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua17)
    for id in ua17:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


--- 

---  zelte

function createarmy18()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4
	end	
    UA18 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA18:AddCommandMove(GetPosition("Burg_1"), true)
    UA18:AddCommandWaitForIdle(true)	
	UA18:AddCommandMove(GetPosition("Burg_2"), true)
    UA18:AddCommandWaitForIdle(true)	
	UA18:AddCommandMove(GetPosition("Ausenzelt_1"), true)
    UA18:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA18, {
        Position=GetPosition("Ausenzelt_1"),
		Generator = "Ausenzelt1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderPoleArm3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua18)
    for id in ua18:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-- die 2te welle von zelt1

function createarmy19()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA19 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA19:AddCommandMove(GetPosition("Burg_1"), true)
    UA19:AddCommandWaitForIdle(true)	
	UA19:AddCommandMove(GetPosition("Burg_2"), true)
    UA19:AddCommandWaitForIdle(true)	
	UA19:AddCommandMove(GetPosition("Ausenzelt_1"), true)
    UA19:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA19, {
        Position=GetPosition("Ausenzelt_1"),
		Generator = "Ausenzelt1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua19)
    for id in ua19:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-- die 3te welle von zelt 1

function createarmy20()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA20 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA20:AddCommandMove(GetPosition("Burg_1"), true)
    UA20:AddCommandWaitForIdle(true)	
	UA20:AddCommandMove(GetPosition("Burg_2"), true)
    UA20:AddCommandWaitForIdle(true)	
	UA20:AddCommandMove(GetPosition("Ausenzelt_1"), true)
    UA20:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA20, {
        Position=GetPosition("Ausenzelt_1"),
		Generator = "Ausenzelt1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua20)
    for id in ua20:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---

-- die 1te welle von zelt 2

function createarmy21()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA21 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA21:AddCommandMove(GetPosition("Burg_2"), true)
    UA21:AddCommandWaitForIdle(true)	
	UA21:AddCommandMove(GetPosition("Burg_1"), true)
    UA21:AddCommandWaitForIdle(true)	
	UA21:AddCommandMove(GetPosition("Ausenzelt_2"), true)
    UA21:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA21, {
        Position=GetPosition("Ausenzelt_2"),
		Generator = "Ausenzelt2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua21)
    for id in ua21:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-- die 2te welle von zelt 2

function createarmy22()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA22 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA22:AddCommandMove(GetPosition("Burg_2"), true)
    UA22:AddCommandWaitForIdle(true)	
	UA22:AddCommandMove(GetPosition("Burg_1"), true)
    UA22:AddCommandWaitForIdle(true)	
	UA22:AddCommandMove(GetPosition("Ausenzelt_2"), true)
    UA22:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA22, {
        Position=GetPosition("Ausenzelt_2"),
		Generator = "Ausenzelt2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderPoleArm3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderSword3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua22)
    for id in ua22:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-- die 3te welle von zelt 2

function createarmy23()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA23 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA23:AddCommandMove(GetPosition("Burg_2"), true)
    UA23:AddCommandWaitForIdle(true)	
	UA23:AddCommandMove(GetPosition("Burg_1"), true)
    UA23:AddCommandWaitForIdle(true)	
	UA23:AddCommandMove(GetPosition("Ausenzelt_2"), true)
    UA23:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA23, {
        Position=GetPosition("Ausenzelt_2"),
		Generator = "Ausenzelt2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua23)
    for id in ua23:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Insel links unten

---  wave 1

function createarmy24()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4
	end	
    UA24 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA24:AddCommandMove(GetPosition("Burg_1"), true)
    UA24:AddCommandWaitForIdle(true)	
	UA24:AddCommandMove(GetPosition("Burg_2"), true)
    UA24:AddCommandWaitForIdle(true)	
	UA24:AddCommandMove(GetPosition("Insel_Turm_1"), true)
    UA24:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA24, {
        Position=GetPosition("Insel_Turm_1"),
		Generator = "Insel_Turm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua24)
    for id in ua24:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---  wave 2 nach Counter

function createarmy25()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA25 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA25:AddCommandMove(GetPosition("Burg_1"), true)
    UA25:AddCommandWaitForIdle(true)	
	UA25:AddCommandMove(GetPosition("Burg_2"), true)
    UA25:AddCommandWaitForIdle(true)	
	UA25:AddCommandMove(GetPosition("Insel_Turm_1"), true)
    UA25:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA25, {
        Position=GetPosition("Insel_Turm_1"),
		Generator = "Insel_Turm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua25)
    for id in ua25:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---  wave 3 nach Counter

function createarmy26()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA26 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA26:AddCommandMove(GetPosition("Burg_1"), true)
    UA26:AddCommandWaitForIdle(true)	
	UA26:AddCommandMove(GetPosition("Burg_2"), true)
    UA26:AddCommandWaitForIdle(true)	
	UA26:AddCommandMove(GetPosition("Insel_Turm_1"), true)
    UA26:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA26, {
        Position=GetPosition("Insel_Turm_1"),
		Generator = "Insel_Turm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua26)
    for id in ua26:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy27()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA27 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA27:AddCommandMove(GetPosition("Insel_Weg1"), true)
    UA27:AddCommandWaitForIdle(true)	
	UA27:AddCommandMove(GetPosition("Insel_Weg2"), true)
    UA27:AddCommandWaitForIdle(true)	
	UA27:AddCommandMove(GetPosition("Insel_Turm_1"), true)
    UA27:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA27, {
        Position=GetPosition("Insel_Turm_1"),
		Generator = "Insel_Turm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua27)
    for id in ua27:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end



---- Insel 1 rechts unten

---  wave 1

function createarmy28()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA28 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA28:AddCommandMove(GetPosition("Burg_2"), true)
    UA28:AddCommandWaitForIdle(true)	
	UA28:AddCommandMove(GetPosition("Burg_1"), true)
    UA28:AddCommandWaitForIdle(true)	
	UA28:AddCommandMove(GetPosition("Inse2_Turm_2"), true)
    UA28:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA28, {
        Position=GetPosition("Inse2_Turm_2"),
		Generator = "Inse2_Turm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
            {LeaderType=Entities.PU_LeaderBow3, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua28)
    for id in ua28:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---  wave 2 nach Counter

function createarmy29()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA29 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA29:AddCommandMove(GetPosition("Burg_2"), true)
    UA29:AddCommandWaitForIdle(true)	
	UA29:AddCommandMove(GetPosition("Burg_1"), true)
    UA29:AddCommandWaitForIdle(true)	
	UA29:AddCommandMove(GetPosition("Inse2_Turm_2"), true)
    UA29:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA29, {
        Position=GetPosition("Inse2_Turm_2"),
		Generator = "Inse2_Turm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua29)
    for id in ua29:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---  wave 3 nach Counter

function createarmy30()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA30 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA30:AddCommandMove(GetPosition("Burg_2"), true)
    UA30:AddCommandWaitForIdle(true)	
	UA30:AddCommandMove(GetPosition("Burg_1"), true)
    UA30:AddCommandWaitForIdle(true)	
	UA30:AddCommandMove(GetPosition("Inse2_Turm_2"), true)
    UA30:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA30, {
        Position=GetPosition("Inse2_Turm_2"),
		Generator = "Inse2_Turm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua30)
    for id in ua30:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy31()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA31 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA31:AddCommandMove(GetPosition("Inse2_Turm2_Weg1"), true)
    UA31:AddCommandWaitForIdle(true)	
	UA31:AddCommandMove(GetPosition("Inse2_Turm2_Weg2"), true)
    UA31:AddCommandWaitForIdle(true)	
	UA31:AddCommandMove(GetPosition("Inse2_Turm_2"), true)
    UA31:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA31, {
        Position=GetPosition("Inse2_Turm_2"),
		Generator = "Inse2_Turm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua31)
    for id in ua31:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy32()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA32 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA32:AddCommandMove(GetPosition("Feuer_weg2"), true)
    UA32:AddCommandWaitForIdle(true)	
	UA32:AddCommandMove(GetPosition("Feuer_weg1"), true)
    UA32:AddCommandWaitForIdle(true)	
	UA32:AddCommandMove(GetPosition("Feuer_1_Attack"), true)
    UA32:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA32, {
        Position=GetPosition("Feuer_1_Attack"),
		Generator = "Feuer", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua32)
    for id in ua32:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy33()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA33 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA33:AddCommandMove(GetPosition("Feuer1_weg2"), true)
    UA33:AddCommandWaitForIdle(true)	
	UA33:AddCommandMove(GetPosition("Feuer1_weg1"), true)
    UA33:AddCommandWaitForIdle(true)	
	UA33:AddCommandMove(GetPosition("Feuer_2_Attack"), true)
    UA33:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA33, {
        Position=GetPosition("Feuer_2_Attack"),
		Generator = "Feuer1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua33)
    for id in ua33:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy34()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA34 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA34:AddCommandMove(GetPosition("Ruine_2_Weg1"), true)
    UA34:AddCommandWaitForIdle(true)	
	UA34:AddCommandMove(GetPosition("Ruine_2_Weg2"), true)
    UA34:AddCommandWaitForIdle(true)	
	UA34:AddCommandMove(GetPosition("Ruine_2_Attack"), true)
    UA34:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA34, {
        Position=GetPosition("Ruine_2_Attack"),
		Generator = "Ruine_2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua34)
    for id in ua34:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy35()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA35 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA35:AddCommandMove(GetPosition("Ruine_1_Weg1"), true)
    UA35:AddCommandWaitForIdle(true)	
	UA35:AddCommandMove(GetPosition("Ruine_1_Weg2"), true)
    UA35:AddCommandWaitForIdle(true)	
	UA35:AddCommandMove(GetPosition("Ruine_1_Attack"), true)
    UA35:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA35, {
        Position=GetPosition("Ruine_1_Attack"),
		Generator = "Ruine_1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua35)
    for id in ua35:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy36()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA36 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA36:AddCommandMove(GetPosition("DerPosten1_Weg1"), true)
    UA36:AddCommandWaitForIdle(true)	
	UA36:AddCommandMove(GetPosition("DerPosten1_Weg2"), true)
    UA36:AddCommandWaitForIdle(true)	
	UA36:AddCommandMove(GetPosition("DerPosten1_Attack"), true)
    UA36:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA36, {
        Position=GetPosition("DerPosten1_Attack"),
		Generator = "DerPosten1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua36)
    for id in ua36:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy37()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3
	end	
    UA37 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA37:AddCommandMove(GetPosition("DerPosten1_Weg2"), true)
    UA37:AddCommandWaitForIdle(true)	
	UA37:AddCommandMove(GetPosition("DerPosten1_Weg1"), true)
    UA37:AddCommandWaitForIdle(true)	
	UA37:AddCommandMove(GetPosition("DerPosten1_Attack"), true)
    UA37:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA37, {
        Position=GetPosition("DerPosten1_Attack"),
		Generator = "DerPosten1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua37)
    for id in ua37:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Attack armmy burg insel

function createarmy38()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 5 
	elseif gv_difficulty == 2
	then
	LeaderCount = 10 
	end	
    UA38 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA38:AddCommandMove(GetPosition("DerPosten1_Weg1"), true)
    UA38:AddCommandWaitForIdle(true)
    UA38:AddCommandMove(GetPosition("Weg1_Unten0"), true)
    UA38:AddCommandWaitForIdle(true)
	UA38:AddCommandMove(GetPosition("Weg1_Unten1"), true)
    UA38:AddCommandWaitForIdle(true)		
	UA38:AddCommandMove(GetPosition("Weg1_Unten2"), true)
    UA38:AddCommandWaitForIdle(true)
	UA38:AddCommandMove(GetPosition("Burg1"), true)
    UA38:AddCommandWaitForIdle(true)
	UA38:AddCommandMove(GetPosition("Burg2"), true)
    UA38:AddCommandWaitForIdle(true)		
	UA38:AddCommandMove(GetPosition("DerPosten1_Attack"), true)
    UA38:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA38, {
        Position=GetPosition("DerPosten1_Attack"),
		Generator = "DerPosten1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua38)
    for id in ua38:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Attack armmy burg insel wave 1

function createarmy39()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA39 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA39:AddCommandMove(GetPosition("DerPosten1_Weg1"), true)
    UA39:AddCommandWaitForIdle(true)
    UA39:AddCommandMove(GetPosition("Weg1_Unten0"), true)
    UA39:AddCommandWaitForIdle(true)
	UA39:AddCommandMove(GetPosition("Weg1_Unten1"), true)
    UA39:AddCommandWaitForIdle(true)		
	UA39:AddCommandMove(GetPosition("Weg1_Unten2"), true)
    UA39:AddCommandWaitForIdle(true)
	UA39:AddCommandMove(GetPosition("Burg1"), true)
    UA39:AddCommandWaitForIdle(true)
	UA39:AddCommandMove(GetPosition("Burg2"), true)
    UA39:AddCommandWaitForIdle(true)		
	UA39:AddCommandMove(GetPosition("DerPosten1_Attack"), true)
    UA39:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA39, {
        Position=GetPosition("DerPosten1_Attack"),
		Generator = "DerPosten1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua39)
    for id in ua39:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Attack armmy burg insel wave 2

function createarmy40()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA40 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA40:AddCommandMove(GetPosition("DerPosten1_Weg1"), true)
    UA40:AddCommandWaitForIdle(true)
    UA40:AddCommandMove(GetPosition("Weg1_Unten0"), true)
    UA40:AddCommandWaitForIdle(true)
	UA40:AddCommandMove(GetPosition("Weg1_Unten1"), true)
    UA40:AddCommandWaitForIdle(true)		
	UA40:AddCommandMove(GetPosition("Weg1_Unten2"), true)
    UA40:AddCommandWaitForIdle(true)
	UA40:AddCommandMove(GetPosition("Burg1"), true)
    UA40:AddCommandWaitForIdle(true)
	UA40:AddCommandMove(GetPosition("Burg2"), true)
    UA40:AddCommandWaitForIdle(true)		
	UA40:AddCommandMove(GetPosition("DerPosten1_Attack"), true)
    UA40:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA40, {
        Position=GetPosition("DerPosten1_Attack"),
		Generator = "DerPosten1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua40)
    for id in ua40:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy41()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA41 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA41:AddCommandMove(GetPosition("DerPosten2_Weg2"), true)
    UA41:AddCommandWaitForIdle(true)	
	UA41:AddCommandMove(GetPosition("DerPosten2_Weg1"), true)
    UA41:AddCommandWaitForIdle(true)	
	UA41:AddCommandMove(GetPosition("DerPosten2_Attack"), true)
    UA41:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA41, {
        Position=GetPosition("DerPosten2_Attack"),
		Generator = "DerPosten2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua41)
    for id in ua41:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- deff army

function createarmy42()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA42 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA42:AddCommandMove(GetPosition("DerPosten2_Weg1"), true)
    UA42:AddCommandWaitForIdle(true)	
	UA42:AddCommandMove(GetPosition("DerPosten2_Weg2"), true)
    UA42:AddCommandWaitForIdle(true)	
	UA42:AddCommandMove(GetPosition("DerPosten2_Attack"), true)
    UA42:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA42, {
        Position=GetPosition("DerPosten2_Attack"),
		Generator = "DerPosten2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua42)
    for id in ua42:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Attack armmy burg insel wave 1

function createarmy43()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 5 
	elseif gv_difficulty == 2
	then
	LeaderCount = 10 
	end	
    UA43 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA43:AddCommandMove(GetPosition("DerPosten2_Weg1"), true)
    UA43:AddCommandWaitForIdle(true)
    UA43:AddCommandMove(GetPosition("Weg1_Oben0"), true)
    UA43:AddCommandWaitForIdle(true)
	UA43:AddCommandMove(GetPosition("Weg1_Oben1"), true)
    UA43:AddCommandWaitForIdle(true)		
	UA43:AddCommandMove(GetPosition("Weg1_Oben2"), true)
    UA43:AddCommandWaitForIdle(true)
	UA43:AddCommandMove(GetPosition("Burg2"), true)
    UA43:AddCommandWaitForIdle(true)
	UA43:AddCommandMove(GetPosition("Burg1"), true)
    UA43:AddCommandWaitForIdle(true)		
	UA43:AddCommandMove(GetPosition("DerPosten2_Attack"), true)
    UA43:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA43, {
        Position=GetPosition("DerPosten2_Attack"),
		Generator = "DerPosten2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua43)
    for id in ua43:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Attack armmy burg insel wave 2

function createarmy44()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA44 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA44:AddCommandMove(GetPosition("DerPosten2_Weg1"), true)
    UA44:AddCommandWaitForIdle(true)
    UA44:AddCommandMove(GetPosition("Weg1_Oben0"), true)
    UA44:AddCommandWaitForIdle(true)
	UA44:AddCommandMove(GetPosition("Weg1_Oben1"), true)
    UA44:AddCommandWaitForIdle(true)		
	UA44:AddCommandMove(GetPosition("Weg1_Oben2"), true)
    UA44:AddCommandWaitForIdle(true)
	UA44:AddCommandMove(GetPosition("Burg2"), true)
    UA44:AddCommandWaitForIdle(true)
	UA44:AddCommandMove(GetPosition("Burg1"), true)
    UA44:AddCommandWaitForIdle(true)		
	UA44:AddCommandMove(GetPosition("DerPosten2_Attack"), true)
    UA44:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA44, {
        Position=GetPosition("DerPosten2_Attack"),
		Generator = "DerPosten2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua44)
    for id in ua44:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- Attack armmy burg insel wave 3

function createarmy45()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA45 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA45:AddCommandMove(GetPosition("DerPosten2_Weg1"), true)
    UA45:AddCommandWaitForIdle(true)
    UA45:AddCommandMove(GetPosition("Weg1_Oben0"), true)
    UA45:AddCommandWaitForIdle(true)
	UA45:AddCommandMove(GetPosition("Weg1_Oben1"), true)
    UA45:AddCommandWaitForIdle(true)		
	UA45:AddCommandMove(GetPosition("Weg1_Oben2"), true)
    UA45:AddCommandWaitForIdle(true)
	UA45:AddCommandMove(GetPosition("Burg2"), true)
    UA45:AddCommandWaitForIdle(true)
	UA45:AddCommandMove(GetPosition("Burg1"), true)
    UA45:AddCommandWaitForIdle(true)		
	UA45:AddCommandMove(GetPosition("DerPosten2_Attack"), true)
    UA45:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA45, {
        Position=GetPosition("DerPosten2_Attack"),
		Generator = "DerPosten2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=4,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua45)
    for id in ua45:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- danach die turm Insel. unten deff

function createarmy46()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA46 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA46:AddCommandMove(GetPosition("Kanonturm_1_Weg1"), true)
    UA46:AddCommandWaitForIdle(true)
    UA46:AddCommandMove(GetPosition("Kanonturm_1_Weg2"), true)
    UA46:AddCommandWaitForIdle(true)		
	UA46:AddCommandMove(GetPosition("Kanonturm_1"), true)
    UA46:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA46, {
        Position=GetPosition("Kanonturm_1"),
		Generator = "Kanonturm", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua46)
    for id in ua46:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- danach die turm Insel. unten armee attack mit counter

function createarmy47()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA47 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA47:AddCommandMove(GetPosition("Kanonturm_1_Weg3"), true)
    UA47:AddCommandWaitForIdle(true)
    UA47:AddCommandMove(GetPosition("Kanonturm_1_Weg4"), true)
    UA47:AddCommandWaitForIdle(true)
    UA47:AddCommandMove(GetPosition("Kanonturm_1_Weg5"), true)
    UA47:AddCommandWaitForIdle(true)
    UA47:AddCommandMove(GetPosition("Kanonturm_1_Weg6"), true)
    UA47:AddCommandWaitForIdle(true)		
    UA47:AddCommandMove(GetPosition("Burg1"), true)
    UA47:AddCommandWaitForIdle(true)
    UA47:AddCommandMove(GetPosition("Burg2"), true)
    UA47:AddCommandWaitForIdle(true)	
	UA47:AddCommandMove(GetPosition("Kanonturm_1"), true)
    UA47:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA47, {
        Position=GetPosition("Kanonturm_1"),
		Generator = "Kanonturm", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua47)
    for id in ua47:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- danach die turm Insel. oben deff

function createarmy48()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA48 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA48:AddCommandMove(GetPosition("Kanonturm_2_Weg1"), true)
    UA48:AddCommandWaitForIdle(true)
    UA48:AddCommandMove(GetPosition("Kanonturm_2_Weg2"), true)
    UA48:AddCommandWaitForIdle(true)		
	UA48:AddCommandMove(GetPosition("Kanonturm_2"), true)
    UA48:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA48, {
        Position=GetPosition("Kanonturm_2"),
		Generator = "Kanonturm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua48)
    for id in ua48:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- danach die turm Insel. unten armee attack mit counter

function createarmy49()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA49 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA49:AddCommandMove(GetPosition("Kanonturm_2_Weg3"), true)
    UA49:AddCommandWaitForIdle(true)
    UA49:AddCommandMove(GetPosition("Kanonturm_2_Weg4"), true)
    UA49:AddCommandWaitForIdle(true)
    UA49:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA49:AddCommandWaitForIdle(true)
    UA49:AddCommandMove(GetPosition("Kanonturm_2_Weg6"), true)
    UA49:AddCommandWaitForIdle(true)		
    UA49:AddCommandMove(GetPosition("Burg2"), true)
    UA49:AddCommandWaitForIdle(true)
    UA49:AddCommandMove(GetPosition("Burg1"), true)
    UA49:AddCommandWaitForIdle(true)	
	UA49:AddCommandMove(GetPosition("Kanonturm_2"), true)
    UA49:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA49, {
        Position=GetPosition("Kanonturm_2"),
		Generator = "Kanonturm2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(ua49)
    for id in ua49:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- danach Turmruine1 links

function createarmy50()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA50 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA50:AddCommandMove(GetPosition("Kanonturm_1_Weg4"), true)
    UA50:AddCommandWaitForIdle(true)
    UA50:AddCommandMove(GetPosition("Kanonturm_1_Weg5"), true)
    UA50:AddCommandWaitForIdle(true)
    UA50:AddCommandMove(GetPosition("Kanonturm_1_Weg6"), true)
    UA50:AddCommandWaitForIdle(true)		
    UA50:AddCommandMove(GetPosition("Burg1"), true)
    UA50:AddCommandWaitForIdle(true)
    UA50:AddCommandMove(GetPosition("Burg2"), true)
    UA50:AddCommandWaitForIdle(true)	
	UA50:AddCommandMove(GetPosition("Turmruine1_1"), true)
    UA50:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA50, {
        Position=GetPosition("Turmruine1_1"),
		Generator = "Turmruine1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA50)
    for id in UA50:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--- danach Turmruine1 rechts

function createarmy51()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA51 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA51:AddCommandMove(GetPosition("Kanonturm_2_Weg4"), true)
    UA51:AddCommandWaitForIdle(true)
    UA51:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA51:AddCommandWaitForIdle(true)
    UA51:AddCommandMove(GetPosition("Kanonturm_2_Weg6"), true)
    UA51:AddCommandWaitForIdle(true)		
    UA51:AddCommandMove(GetPosition("Burg2"), true)
    UA51:AddCommandWaitForIdle(true)
    UA51:AddCommandMove(GetPosition("Burg1"), true)
    UA51:AddCommandWaitForIdle(true)	
	UA51:AddCommandMove(GetPosition("Turmruine2_2"), true)
    UA51:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA51, {
        Position=GetPosition("Turmruine2_2"),
		Generator = "Turmruine2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA51)
    for id in UA51:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


---- zitainsel 1


function createarmy52()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA52 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA52:AddCommandMove(GetPosition("Kanonturm_1_Weg5"), true)
    UA52:AddCommandWaitForIdle(true)
    UA52:AddCommandMove(GetPosition("Kanonturm_1_Weg6"), true)
    UA52:AddCommandWaitForIdle(true)		
    UA52:AddCommandMove(GetPosition("Burg1"), true)
    UA52:AddCommandWaitForIdle(true)
    UA52:AddCommandMove(GetPosition("Burg2"), true)
    UA52:AddCommandWaitForIdle(true)	
	UA52:AddCommandMove(GetPosition("Zita_1_Insel_1"), true)
    UA52:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA52, {
        Position=GetPosition("Zita_1_Insel_1"),
		Generator = "Zita_1_Insel", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA52)
    for id in UA52:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- zitainsel 1  deff


function createarmy53()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA53 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }		
    UA53:AddCommandMove(GetPosition("Zita_1_Weg1"), true)
    UA53:AddCommandWaitForIdle(true)
    UA53:AddCommandMove(GetPosition("Zita_1_Weg2"), true)
    UA53:AddCommandWaitForIdle(true)	
	UA53:AddCommandMove(GetPosition("Zita_1_Insel_1"), true)
    UA53:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA53, {
        Position=GetPosition("Zita_1_Insel_1"),
		Generator = "Zita_1_Insel", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA53)
    for id in UA53:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


---- zitainsel 1 attack counter


function createarmy54()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA54 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA54:AddCommandMove(GetPosition("Kanonturm_1_Weg5"), true)
    UA54:AddCommandWaitForIdle(true)
    UA54:AddCommandMove(GetPosition("Kanonturm_1_Weg6"), true)
    UA54:AddCommandWaitForIdle(true)		
    UA54:AddCommandMove(GetPosition("Burg1"), true)
    UA54:AddCommandWaitForIdle(true)
    UA54:AddCommandMove(GetPosition("Burg2"), true)
    UA54:AddCommandWaitForIdle(true)	
	UA54:AddCommandMove(GetPosition("Zita_1_Insel_1"), true)
    UA54:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA54, {
        Position=GetPosition("Zita_1_Insel_1"),
		Generator = "Zita_1_Insel", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA54)
    for id in UA54:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

---- zitainsel 1 attack counter

function createarmy55()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA55 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA55:AddCommandMove(GetPosition("Kanonturm_1_Weg5"), true)
    UA55:AddCommandWaitForIdle(true)
    UA55:AddCommandMove(GetPosition("Kanonturm_1_Weg6"), true)
    UA55:AddCommandWaitForIdle(true)		
    UA55:AddCommandMove(GetPosition("Burg1"), true)
    UA55:AddCommandWaitForIdle(true)
    UA55:AddCommandMove(GetPosition("Burg2"), true)
    UA55:AddCommandWaitForIdle(true)	
	UA55:AddCommandMove(GetPosition("Zita_1_Insel_1"), true)
    UA55:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA55, {
        Position=GetPosition("Zita_1_Insel_1"),
		Generator = "Zita_1_Insel", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA55)
    for id in UA55:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-------
---FeldTurm1
-------

function createarmy56()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA56 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA56:AddCommandMove(GetPosition("FeldTurm1_Weg1"), true)
    UA56:AddCommandWaitForIdle(true)
    UA56:AddCommandMove(GetPosition("FeldTurm1_Weg2"), true)
    UA56:AddCommandWaitForIdle(true)		
    UA56:AddCommandMove(GetPosition("Burg1"), true)
    UA56:AddCommandWaitForIdle(true)
    UA56:AddCommandMove(GetPosition("Burg2"), true)
    UA56:AddCommandWaitForIdle(true)	
	UA56:AddCommandMove(GetPosition("FeldTurm1_1"), true)
    UA56:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA56, {
        Position=GetPosition("FeldTurm1_1"),
		Generator = "FeldTurm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA56)
    for id in UA56:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-------
---FeldTurm1 deff
-------

function createarmy57()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA57 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA57:AddCommandMove(GetPosition("FeldTurm1_Weg4"), true)
    UA57:AddCommandWaitForIdle(true)
    UA57:AddCommandMove(GetPosition("FeldTurm1_Weg5"), true)
    UA57:AddCommandWaitForIdle(true)
    UA57:AddCommandMove(GetPosition("FeldTurm1_Weg6"), true)
    UA57:AddCommandWaitForIdle(true)		
	UA57:AddCommandMove(GetPosition("FeldTurm1_1"), true)
    UA57:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA57, {
        Position=GetPosition("FeldTurm1_1"),
		Generator = "FeldTurm1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA57)
    for id in UA57:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- FeldRuine1 Links attack
-----

function createarmy58()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA58 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA58:AddCommandMove(GetPosition("FeldRuine1_Weg1"), true)
    UA58:AddCommandWaitForIdle(true)
    UA58:AddCommandMove(GetPosition("FeldRuine1_Weg2"), true)
    UA58:AddCommandWaitForIdle(true)		
    UA58:AddCommandMove(GetPosition("Burg1"), true)
    UA58:AddCommandWaitForIdle(true)
    UA58:AddCommandMove(GetPosition("Burg2"), true)
    UA58:AddCommandWaitForIdle(true)	
	UA58:AddCommandMove(GetPosition("FeldRuine1_1"), true)
    UA58:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA58, {
        Position=GetPosition("FeldRuine1_1"),
		Generator = "FeldRuine1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA58)
    for id in UA58:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- FeldRuine1 Links deff
-----

function createarmy59()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA59 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA59:AddCommandMove(GetPosition("FeldRuine1_Weg3"), true)
    UA59:AddCommandWaitForIdle(true)
    UA59:AddCommandMove(GetPosition("FeldRuine1_Weg4"), true)
    UA59:AddCommandWaitForIdle(true)			
	UA59:AddCommandMove(GetPosition("FeldRuine1_1"), true)
    UA59:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA59, {
        Position=GetPosition("FeldRuine1_1"),
		Generator = "FeldRuine1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=5,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA59)
    for id in UA59:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- FeldRuine1 Links attack
-----

function createarmy60()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA60 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA60:AddCommandMove(GetPosition("FeldRuine1_Weg1"), true)
    UA60:AddCommandWaitForIdle(true)
    UA60:AddCommandMove(GetPosition("FeldRuine1_Weg2"), true)
    UA60:AddCommandWaitForIdle(true)			
	UA60:AddCommandMove(GetPosition("Burg1"), true)
    UA60:AddCommandWaitForIdle(true)
	UA60:AddCommandMove(GetPosition("Burg2"), true)
    UA60:AddCommandWaitForIdle(true)		
    UnlimitedArmySpawnGenerator:New(UA60, {
        Position=GetPosition("FeldRuine1_1"),
		Generator = "FeldRuine1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA60)
    for id in UA60:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
--- FeldRuine1 rechts attack
-----

function createarmy61()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA61 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA61:AddCommandMove(GetPosition("FeldRuine2_Weg1"), true)
    UA61:AddCommandWaitForIdle(true)
    UA61:AddCommandMove(GetPosition("FeldRuine2_Weg2"), true)
    UA61:AddCommandWaitForIdle(true)			
	UA61:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA61:AddCommandWaitForIdle(true)
	UA61:AddCommandMove(GetPosition("Burg2"), true)
    UA61:AddCommandWaitForIdle(true)	
	UA61:AddCommandMove(GetPosition("Burg1"), true)
    UA61:AddCommandWaitForIdle(true)		
    UnlimitedArmySpawnGenerator:New(UA61, {
        Position=GetPosition("FeldRuine2_1"),
		Generator = "FeldRuine2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA61)
    for id in UA61:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
--- FeldRuine1 rechts deff
-----

function createarmy62()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA62 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA62:AddCommandMove(GetPosition("FeldRuine2_Weg1"), true)
    UA62:AddCommandWaitForIdle(true)
    UA62:AddCommandMove(GetPosition("FeldRuine2_Weg2"), true)
    UA62:AddCommandWaitForIdle(true)
	UA62:AddCommandMove(GetPosition("FeldRuine2_Weg3"), true)
    UA62:AddCommandWaitForIdle(true)
    UA62:AddCommandMove(GetPosition("FeldRuine2_Weg4"), true)
    UA62:AddCommandWaitForIdle(true)
    UA62:AddCommandMove(GetPosition("FeldRuine2_1"), true)
    UA62:AddCommandWaitForIdle(true)		
    UnlimitedArmySpawnGenerator:New(UA62, {
        Position=GetPosition("FeldRuine2_1"),
		Generator = "FeldRuine2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA62)
    for id in UA62:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- FeldRuine1 rechts  attack
-----

function createarmy63()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA63 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA63:AddCommandMove(GetPosition("FeldRuine2_Weg1"), true)
    UA63:AddCommandWaitForIdle(true)
    UA63:AddCommandMove(GetPosition("FeldRuine2_Weg2"), true)
    UA63:AddCommandWaitForIdle(true)			
	UA63:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA63:AddCommandWaitForIdle(true)
	UA63:AddCommandMove(GetPosition("Burg2"), true)
    UA63:AddCommandWaitForIdle(true)	
	UA63:AddCommandMove(GetPosition("Burg1"), true)
    UA63:AddCommandWaitForIdle(true)			
    UnlimitedArmySpawnGenerator:New(UA63, {
        Position=GetPosition("FeldRuine2_1"),
		Generator = "FeldRuine2", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA63)
    for id in UA63:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- Zita rechts  deff
-----

function createarmy64()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA64 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA64:AddCommandMove(GetPosition("Zita2_rechts_Weg1"), true)
    UA64:AddCommandWaitForIdle(true)
    UA64:AddCommandMove(GetPosition("Zita2_rechts_Weg2"), true)
    UA64:AddCommandWaitForIdle(true)			
	UA64:AddCommandMove(GetPosition("Zita2_rechts1_1"), true)
    UA64:AddCommandWaitForIdle(true)				
    UnlimitedArmySpawnGenerator:New(UA64, {
        Position=GetPosition("Zita2_rechts1_1"),
		Generator = "Zita2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA64)
    for id in UA64:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
--- Zita rechts  army attack
-----

function createarmy65()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA65 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA65:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA65:AddCommandWaitForIdle(true)
    UA65:AddCommandMove(GetPosition("Burg2"), true)
    UA65:AddCommandWaitForIdle(true)			
	UA65:AddCommandMove(GetPosition("Burg1"), true)
    UA65:AddCommandWaitForIdle(true)	
	UA65:AddCommandMove(GetPosition("Zita2_rechts1_1"), true)
    UA65:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA65, {
        Position=GetPosition("Zita2_rechts1_1"),
		Generator = "Zita2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA65)
    for id in UA65:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
--- Zita rechts  army attack counter
-----

function createarmy66()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA66 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA66:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA66:AddCommandWaitForIdle(true)
    UA66:AddCommandMove(GetPosition("Burg2"), true)
    UA66:AddCommandWaitForIdle(true)			
	UA66:AddCommandMove(GetPosition("Burg1"), true)
    UA66:AddCommandWaitForIdle(true)	
	UA66:AddCommandMove(GetPosition("Zita2_rechts1_1"), true)
    UA66:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA66, {
        Position=GetPosition("Zita2_rechts1_1"),
		Generator = "Zita2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA66)
    for id in UA66:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
--- Zita rechts  army attack counter 1
-----

function createarmy67()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA67 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA67:AddCommandMove(GetPosition("Kanonturm_2_Weg5"), true)
    UA67:AddCommandWaitForIdle(true)
    UA67:AddCommandMove(GetPosition("Burg2"), true)
    UA67:AddCommandWaitForIdle(true)			
	UA67:AddCommandMove(GetPosition("Burg1"), true)
    UA67:AddCommandWaitForIdle(true)	
	UA67:AddCommandMove(GetPosition("Zita2_rechts1_1"), true)
    UA67:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA67, {
        Position=GetPosition("Zita2_rechts1_1"),
		Generator = "Zita2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA67)
    for id in UA67:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- Feldturm2 rechts  deff
-----

function createarmy68()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 4 
	end	
    UA68 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA68:AddCommandMove(GetPosition("Feldturm2_Weg1"), true)
    UA68:AddCommandWaitForIdle(true)
    UA68:AddCommandMove(GetPosition("Feldturm2_Weg2"), true)
    UA68:AddCommandWaitForIdle(true)			
	UA68:AddCommandMove(GetPosition("Feldturm2_Weg3"), true)
    UA68:AddCommandWaitForIdle(true)	
	UA68:AddCommandMove(GetPosition("Feldturm2_rechts1_1"), true)
    UA68:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA68, {
        Position=GetPosition("Feldturm2_rechts1_1"),
		Generator = "Feldturm2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA68)
    for id in UA68:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
--- Feldturm2 rechts  army
-----

function createarmy69()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA69 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA69:AddCommandMove(GetPosition("Feldturm2_Weg4"), true)
    UA69:AddCommandWaitForIdle(true)
    UA69:AddCommandMove(GetPosition("Feldturm2_Weg5"), true)
    UA69:AddCommandWaitForIdle(true)			
	UA69:AddCommandMove(GetPosition("Burg2"), true)
    UA69:AddCommandWaitForIdle(true)	
	UA69:AddCommandMove(GetPosition("Burg1"), true)
    UA69:AddCommandWaitForIdle(true)
	UA69:AddCommandMove(GetPosition("Feldturm2_rechts1_1"), true)
    UA69:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA69, {
        Position=GetPosition("Feldturm2_rechts1_1"),
		Generator = "Feldturm2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA69)
    for id in UA69:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte als erstes   nach den Snowbarries  armee
-----

function createarmy70()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA70 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA70:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg1"), true)
    UA70:AddCommandWaitForIdle(true)
    UA70:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg2"), true)
    UA70:AddCommandWaitForIdle(true)			
	UA70:AddCommandMove(GetPosition("Burg2"), true)
    UA70:AddCommandWaitForIdle(true)	
	UA70:AddCommandMove(GetPosition("Burg1"), true)
    UA70:AddCommandWaitForIdle(true)
	UA70:AddCommandMove(GetPosition("Festung_MitteFront_1"), true)
    UA70:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA70, {
        Position=GetPosition("Festung_MitteFront_1"),
		Generator = "Festung_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA70)
    for id in UA70:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Der Ganz Obere Teil Mitte als erstes   armee 2
-----

function createarmy71()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA71 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA71:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg1"), true)
    UA71:AddCommandWaitForIdle(true)
    UA71:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg2"), true)
    UA71:AddCommandWaitForIdle(true)			
	UA71:AddCommandMove(GetPosition("Burg2"), true)
    UA71:AddCommandWaitForIdle(true)	
	UA71:AddCommandMove(GetPosition("Burg1"), true)
    UA71:AddCommandWaitForIdle(true)
	UA71:AddCommandMove(GetPosition("Festung_MitteFront_1"), true)
    UA71:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA71, {
        Position=GetPosition("Festung_MitteFront_1"),
		Generator = "Festung_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA71)
    for id in UA71:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte als erstes   armee 3
-----

function createarmy72()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA72 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA72:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg1"), true)
    UA72:AddCommandWaitForIdle(true)
    UA72:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg2"), true)
    UA72:AddCommandWaitForIdle(true)			
	UA72:AddCommandMove(GetPosition("Burg2"), true)
    UA72:AddCommandWaitForIdle(true)	
	UA72:AddCommandMove(GetPosition("Burg1"), true)
    UA72:AddCommandWaitForIdle(true)
	UA72:AddCommandMove(GetPosition("Festung_MitteFront_1"), true)
    UA72:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA72, {
        Position=GetPosition("Festung_MitteFront_1"),
		Generator = "Festung_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA72)
    for id in UA72:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte als erstes   armee 4
-----

function createarmy73()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA73 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA73:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg1"), true)
    UA73:AddCommandWaitForIdle(true)
    UA73:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg2"), true)
    UA73:AddCommandWaitForIdle(true)			
	UA73:AddCommandMove(GetPosition("Burg1"), true)
    UA73:AddCommandWaitForIdle(true)	
	UA73:AddCommandMove(GetPosition("Burg2"), true)
    UA73:AddCommandWaitForIdle(true)
	UA73:AddCommandMove(GetPosition("Festung_MitteFront_1"), true)
    UA73:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA73, {
        Position=GetPosition("Festung_MitteFront_1"),
		Generator = "Festung_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA73)
    for id in UA73:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte als erstes   armee 5
-----

function createarmy74()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA74 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA74:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg1"), true)
    UA74:AddCommandWaitForIdle(true)
    UA74:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg2"), true)
    UA74:AddCommandWaitForIdle(true)			
	UA74:AddCommandMove(GetPosition("Burg1"), true)
    UA74:AddCommandWaitForIdle(true)	
	UA74:AddCommandMove(GetPosition("Burg2"), true)
    UA74:AddCommandWaitForIdle(true)
	UA74:AddCommandMove(GetPosition("Festung_MitteFront_1"), true)
    UA74:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA74, {
        Position=GetPosition("Festung_MitteFront_1"),
		Generator = "Festung_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA74)
    for id in UA74:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte als erstes   armee 6
-----

function createarmy75()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7 
	end	
    UA75 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA75:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg1"), true)
    UA75:AddCommandWaitForIdle(true)
    UA75:AddCommandMove(GetPosition("Festung_MitteFront_1_Weg2"), true)
    UA75:AddCommandWaitForIdle(true)			
	UA75:AddCommandMove(GetPosition("Burg1"), true)
    UA75:AddCommandWaitForIdle(true)	
	UA75:AddCommandMove(GetPosition("Burg2"), true)
    UA75:AddCommandWaitForIdle(true)
	UA75:AddCommandMove(GetPosition("Festung_MitteFront_1"), true)
    UA75:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA75, {
        Position=GetPosition("Festung_MitteFront_1"),
		Generator = "Festung_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA75)
    for id in UA75:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte 
-----

function createarmy76()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA76 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA76:AddCommandMove(GetPosition("Mitte_Front1"), true)
    UA76:AddCommandWaitForIdle(true)			
	UA76:AddCommandMove(GetPosition("Burg1"), true)
    UA76:AddCommandWaitForIdle(true)	
	UA76:AddCommandMove(GetPosition("Burg2"), true)
    UA76:AddCommandWaitForIdle(true)
	UA76:AddCommandMove(GetPosition("KanonM1_rechts1_1"), true)
    UA76:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA76, {
        Position=GetPosition("KanonM1_rechts1_1"),
		Generator = "KanonM_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA76)
    for id in UA76:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte 
-----

function createarmy77()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA77 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA77:AddCommandMove(GetPosition("Mitte_Front1"), true)
    UA77:AddCommandWaitForIdle(true)			
	UA77:AddCommandMove(GetPosition("Burg1"), true)
    UA77:AddCommandWaitForIdle(true)	
	UA77:AddCommandMove(GetPosition("Burg2"), true)
    UA77:AddCommandWaitForIdle(true)
	UA77:AddCommandMove(GetPosition("KanonM1_rechts1_1"), true)
    UA77:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA77, {
        Position=GetPosition("KanonM1_rechts1_1"),
		Generator = "KanonM_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA77)
    for id in UA77:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte 
-----

function createarmy78()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2
	end	
    UA78 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA78:AddCommandMove(GetPosition("Mitte_Front2"), true)
    UA78:AddCommandWaitForIdle(true)			
	UA78:AddCommandMove(GetPosition("Burg2"), true)
    UA78:AddCommandWaitForIdle(true)	
	UA78:AddCommandMove(GetPosition("Burg1"), true)
    UA78:AddCommandWaitForIdle(true)
	UA78:AddCommandMove(GetPosition("KanonM1_rechts1_1"), true)
    UA78:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA78, {
        Position=GetPosition("KanonM1_rechts1_1"),
		Generator = "KanonM_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA78)
    for id in UA78:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte 
-----

function createarmy79()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 2 
	end	
    UA79 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA79:AddCommandMove(GetPosition("Mitte_Front2"), true)
    UA79:AddCommandWaitForIdle(true)			
	UA79:AddCommandMove(GetPosition("Burg2"), true)
    UA79:AddCommandWaitForIdle(true)	
	UA79:AddCommandMove(GetPosition("Burg1"), true)
    UA79:AddCommandWaitForIdle(true)
	UA79:AddCommandMove(GetPosition("KanonM1_rechts1_1"), true)
    UA79:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA79, {
        Position=GetPosition("KanonM1_rechts1_1"),
		Generator = "KanonM_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA79)
    for id in UA79:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte  reiter
-----

function createarmy80()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA80 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA80:AddCommandMove(GetPosition("Mitte_Front2"), true)
    UA80:AddCommandWaitForIdle(true)			
	UA80:AddCommandMove(GetPosition("Burg2"), true)
    UA80:AddCommandWaitForIdle(true)	
	UA80:AddCommandMove(GetPosition("Burg1"), true)
    UA80:AddCommandWaitForIdle(true)
	UA80:AddCommandMove(GetPosition("Reiterei_Mitte1_1"), true)
    UA80:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA80, {
        Position=GetPosition("Reiterei_Mitte1_1"),
		Generator = "Reiterei_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA80)
    for id in UA80:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte  reiter
-----

function createarmy81()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA81 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA81:AddCommandMove(GetPosition("Mitte_Front2"), true)
    UA81:AddCommandWaitForIdle(true)			
	UA81:AddCommandMove(GetPosition("Burg2"), true)
    UA81:AddCommandWaitForIdle(true)	
	UA81:AddCommandMove(GetPosition("Burg1"), true)
    UA81:AddCommandWaitForIdle(true)
	UA81:AddCommandMove(GetPosition("Reiterei_Mitte1_1"), true)
    UA81:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA81, {
        Position=GetPosition("Reiterei_Mitte1_1"),
		Generator = "Reiterei_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA81)
    for id in UA81:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte  reiter
-----

function createarmy82()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA82 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA82:AddCommandMove(GetPosition("Mitte_Front1"), true)
    UA82:AddCommandWaitForIdle(true)			
	UA82:AddCommandMove(GetPosition("Burg1"), true)
    UA82:AddCommandWaitForIdle(true)	
	UA82:AddCommandMove(GetPosition("Burg2"), true)
    UA82:AddCommandWaitForIdle(true)
	UA82:AddCommandMove(GetPosition("Reiterei_Mitte1_1"), true)
    UA82:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA82, {
        Position=GetPosition("Reiterei_Mitte1_1"),
		Generator = "Reiterei_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA82)
    for id in UA82:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte  reiter
-----

function createarmy83()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6
	end	
    UA83 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA83:AddCommandMove(GetPosition("Mitte_Front1"), true)
    UA83:AddCommandWaitForIdle(true)			
	UA83:AddCommandMove(GetPosition("Burg1"), true)
    UA83:AddCommandWaitForIdle(true)	
	UA83:AddCommandMove(GetPosition("Burg2"), true)
    UA83:AddCommandWaitForIdle(true)
	UA83:AddCommandMove(GetPosition("Reiterei_Mitte1_1"), true)
    UA83:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA83, {
        Position=GetPosition("Reiterei_Mitte1_1"),
		Generator = "Reiterei_MitteFront", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=4, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA83)
    for id in UA83:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Der Ganz Obere Teil Mitte  deff links
-----

function createarmy84()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA84 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA84:AddCommandMove(GetPosition("Kaserne1_Mitte_Weg1"), true)
    UA84:AddCommandWaitForIdle(true)			
	UA84:AddCommandMove(GetPosition("Kaserne1_Mitte_Weg2"), true)
    UA84:AddCommandWaitForIdle(true)	
	UA84:AddCommandMove(GetPosition("Kaserne1_Mitte_Weg3"), true)
    UA84:AddCommandWaitForIdle(true)
	UA84:AddCommandMove(GetPosition("Kaserne1_Mitte1"), true)
    UA84:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA84, {
        Position=GetPosition("Kaserne1_Mitte1"),
		Generator = "Kaserne1_Mitte", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA84)
    for id in UA84:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil Mitte  deff rechts
-----

function createarmy85()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 6 
	end	
    UA85 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA85:AddCommandMove(GetPosition("platz1_Mitte_Weg1"), true)
    UA85:AddCommandWaitForIdle(true)			
	UA85:AddCommandMove(GetPosition("platz1_Mitte_Weg2"), true)
    UA85:AddCommandWaitForIdle(true)	
	UA85:AddCommandMove(GetPosition("platz1_Mitte_Weg3"), true)
    UA85:AddCommandWaitForIdle(true)
	UA85:AddCommandMove(GetPosition("platz1_Mitte1"), true)
    UA85:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA85, {
        Position=GetPosition("platz1_Mitte1"),
		Generator = "platz1_Mitte", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA85)
    for id in UA85:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita links Oben wave1
-----

function createarmy86()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA86 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA86:AddCommandMove(GetPosition("ZitaLinks_Weg1"), true)
    UA86:AddCommandWaitForIdle(true)			
	UA86:AddCommandMove(GetPosition("ZitaLinks_Weg2"), true)
    UA86:AddCommandWaitForIdle(true)	
	UA86:AddCommandMove(GetPosition("ZitaLinks_Weg3"), true)
    UA86:AddCommandWaitForIdle(true)
	UA86:AddCommandMove(GetPosition("ZitaLinks_Weg4"), true)
    UA86:AddCommandWaitForIdle(true)
	UA86:AddCommandMove(GetPosition("ZitaLinks_Weg5"), true)
    UA86:AddCommandWaitForIdle(true)
    UA86:AddCommandMove(GetPosition("Burg1"), true)
    UA86:AddCommandWaitForIdle(true)
    UA86:AddCommandMove(GetPosition("Burg2"), true)
    UA86:AddCommandWaitForIdle(true)
	UA86:AddCommandMove(GetPosition("ZitalinksOben1"), true)
    UA86:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA86, {
        Position=GetPosition("ZitalinksOben1"),
		Generator = "ZitalinksOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA86)
    for id in UA86:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Der Ganz Obere Teil zita links Oben wave2
-----

function createarmy87()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA87 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA87:AddCommandMove(GetPosition("ZitaLinks_Weg1"), true)
    UA87:AddCommandWaitForIdle(true)			
	UA87:AddCommandMove(GetPosition("ZitaLinks_Weg2"), true)
    UA87:AddCommandWaitForIdle(true)	
	UA87:AddCommandMove(GetPosition("ZitaLinks_Weg3"), true)
    UA87:AddCommandWaitForIdle(true)
	UA87:AddCommandMove(GetPosition("ZitaLinks_Weg4"), true)
    UA87:AddCommandWaitForIdle(true)
	UA87:AddCommandMove(GetPosition("ZitaLinks_Weg5"), true)
    UA87:AddCommandWaitForIdle(true)
    UA87:AddCommandMove(GetPosition("Burg1"), true)
    UA87:AddCommandWaitForIdle(true)
    UA87:AddCommandMove(GetPosition("Burg2"), true)
    UA87:AddCommandWaitForIdle(true)
	UA87:AddCommandMove(GetPosition("ZitalinksOben1"), true)
    UA87:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA87, {
        Position=GetPosition("ZitalinksOben1"),
		Generator = "ZitalinksOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA87)
    for id in UA87:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita links Oben wave3
-----

function createarmy88()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA88 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA88:AddCommandMove(GetPosition("ZitaLinks_Weg1"), true)
    UA88:AddCommandWaitForIdle(true)			
	UA88:AddCommandMove(GetPosition("ZitaLinks_Weg2"), true)
    UA88:AddCommandWaitForIdle(true)	
	UA88:AddCommandMove(GetPosition("ZitaLinks_Weg3"), true)
    UA88:AddCommandWaitForIdle(true)
	UA88:AddCommandMove(GetPosition("ZitaLinks_Weg4"), true)
    UA88:AddCommandWaitForIdle(true)
	UA88:AddCommandMove(GetPosition("ZitaLinks_Weg5"), true)
    UA88:AddCommandWaitForIdle(true)
    UA88:AddCommandMove(GetPosition("Burg1"), true)
    UA88:AddCommandWaitForIdle(true)
    UA88:AddCommandMove(GetPosition("Burg2"), true)
    UA88:AddCommandWaitForIdle(true)
	UA88:AddCommandMove(GetPosition("ZitalinksOben1"), true)
    UA88:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA88, {
        Position=GetPosition("ZitalinksOben1"),
		Generator = "ZitalinksOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA88)
    for id in UA88:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita links Oben wave4
-----

function createarmy89()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA89 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA89:AddCommandMove(GetPosition("ZitaLinks_Weg1"), true)
    UA89:AddCommandWaitForIdle(true)			
	UA89:AddCommandMove(GetPosition("ZitaLinks_Weg2"), true)
    UA89:AddCommandWaitForIdle(true)	
	UA89:AddCommandMove(GetPosition("ZitaLinks_Weg3"), true)
    UA89:AddCommandWaitForIdle(true)
	UA89:AddCommandMove(GetPosition("ZitaLinks_Weg4"), true)
    UA89:AddCommandWaitForIdle(true)
	UA89:AddCommandMove(GetPosition("ZitaLinks_Weg5"), true)
    UA89:AddCommandWaitForIdle(true)
    UA89:AddCommandMove(GetPosition("Burg1"), true)
    UA89:AddCommandWaitForIdle(true)
    UA89:AddCommandMove(GetPosition("Burg2"), true)
    UA89:AddCommandWaitForIdle(true)
	UA89:AddCommandMove(GetPosition("ZitalinksOben1"), true)
    UA89:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA89, {
        Position=GetPosition("ZitalinksOben1"),
		Generator = "ZitalinksOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA89)
    for id in UA89:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Der Ganz Obere Teil kaserne links Oben deff
-----

function createarmy90()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA90 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA90:AddCommandMove(GetPosition("KasernelinksOben1_Weg1"), true)
    UA90:AddCommandWaitForIdle(true)	
    UA90:AddCommandMove(GetPosition("KasernelinksOben1"), true)
    UA90:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA90, {
        Position=GetPosition("KasernelinksOben1"),
		Generator = "KasernelinksOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA90)
    for id in UA90:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil kaserne links Oben deff
-----

function createarmy91()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA91 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA91:AddCommandMove(GetPosition("KasernelinksOben1_Weg1"), true)
    UA91:AddCommandWaitForIdle(true)	
    UA91:AddCommandMove(GetPosition("KasernelinksOben1"), true)
    UA91:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA91, {
        Position=GetPosition("KasernelinksOben1"),
		Generator = "KasernelinksOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA91)
    for id in UA91:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil kaserne rechts Oben deff
-----

function createarmy92()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA92 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA92:AddCommandMove(GetPosition("KasernerechtsOben1_Weg1"), true)
    UA92:AddCommandWaitForIdle(true)	
    UA92:AddCommandMove(GetPosition("KasernerechtsOben1"), true)
    UA92:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA92, {
        Position=GetPosition("KasernerechtsOben1"),
		Generator = "KasernerechtsOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA92)
    for id in UA92:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil kaserne rechts Oben deff
-----

function createarmy93()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA93 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA93:AddCommandMove(GetPosition("KasernelinksOben1_Weg1"), true)
    UA93:AddCommandWaitForIdle(true)	
    UA93:AddCommandMove(GetPosition("KasernerechtsOben1"), true)
    UA93:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA93, {
        Position=GetPosition("KasernerechtsOben1"),
		Generator = "KasernerechtsOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA93)
    for id in UA93:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Der Ganz Obere Teil zita rechts Oben wave1
-----

function createarmy94()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA94 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA94:AddCommandMove(GetPosition("zitalinksOben1_Weg1"), true)
    UA94:AddCommandWaitForIdle(true)
    UA94:AddCommandMove(GetPosition("zitalinksOben1_Weg2"), true)
    UA94:AddCommandWaitForIdle(true)
	UA94:AddCommandMove(GetPosition("zitalinksOben1_Weg3"), true)
    UA94:AddCommandWaitForIdle(true)	    
	UA94:AddCommandMove(GetPosition("zitalinksOben1_Weg4"), true)
    UA94:AddCommandWaitForIdle(true)	    
	UA94:AddCommandMove(GetPosition("zitalinksOben1_Weg5"), true)
    UA94:AddCommandWaitForIdle(true)	    
	UA94:AddCommandMove(GetPosition("Burg2"), true)
    UA94:AddCommandWaitForIdle(true)
    UA94:AddCommandMove(GetPosition("Burg1"), true)
    UA94:AddCommandWaitForIdle(true)	
    UA94:AddCommandMove(GetPosition("zitarechtsOben1"), true)
    UA94:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA94, {
        Position=GetPosition("zitarechtsOben1"),
		Generator = "zitarechtsOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA94)
    for id in UA94:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita rechts Oben wave2
-----

function createarmy95()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA95 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA95:AddCommandMove(GetPosition("zitalinksOben1_Weg1"), true)
    UA95:AddCommandWaitForIdle(true)
    UA95:AddCommandMove(GetPosition("zitalinksOben1_Weg2"), true)
    UA95:AddCommandWaitForIdle(true)
	UA95:AddCommandMove(GetPosition("zitalinksOben1_Weg3"), true)
    UA95:AddCommandWaitForIdle(true)	    
	UA95:AddCommandMove(GetPosition("zitalinksOben1_Weg4"), true)
    UA95:AddCommandWaitForIdle(true)	    
	UA95:AddCommandMove(GetPosition("zitalinksOben1_Weg5"), true)
    UA95:AddCommandWaitForIdle(true)	    
	UA95:AddCommandMove(GetPosition("Burg2"), true)
    UA95:AddCommandWaitForIdle(true)
    UA95:AddCommandMove(GetPosition("Burg1"), true)
    UA95:AddCommandWaitForIdle(true)	
    UA95:AddCommandMove(GetPosition("zitarechtsOben1"), true)
    UA95:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA95, {
        Position=GetPosition("zitarechtsOben1"),
		Generator = "zitarechtsOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA95)
    for id in UA95:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita rechts Oben wave3
-----

function createarmy96()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA96 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA96:AddCommandMove(GetPosition("zitalinksOben1_Weg1"), true)
    UA96:AddCommandWaitForIdle(true)
    UA96:AddCommandMove(GetPosition("zitalinksOben1_Weg2"), true)
    UA96:AddCommandWaitForIdle(true)
	UA96:AddCommandMove(GetPosition("zitalinksOben1_Weg3"), true)
    UA96:AddCommandWaitForIdle(true)	    
	UA96:AddCommandMove(GetPosition("zitalinksOben1_Weg4"), true)
    UA96:AddCommandWaitForIdle(true)	    
	UA96:AddCommandMove(GetPosition("zitalinksOben1_Weg5"), true)
    UA96:AddCommandWaitForIdle(true)	    
	UA96:AddCommandMove(GetPosition("Burg2"), true)
    UA96:AddCommandWaitForIdle(true)
    UA96:AddCommandMove(GetPosition("Burg1"), true)
    UA96:AddCommandWaitForIdle(true)	
    UA96:AddCommandMove(GetPosition("zitarechtsOben1"), true)
    UA96:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA96, {
        Position=GetPosition("zitarechtsOben1"),
		Generator = "zitarechtsOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA96)
    for id in UA96:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita rechts Oben wave4
-----

function createarmy97()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 3 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5 
	end	
    UA97 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA97:AddCommandMove(GetPosition("zitalinksOben1_Weg1"), true)
    UA97:AddCommandWaitForIdle(true)
    UA97:AddCommandMove(GetPosition("zitalinksOben1_Weg2"), true)
    UA97:AddCommandWaitForIdle(true)
	UA97:AddCommandMove(GetPosition("zitalinksOben1_Weg3"), true)
    UA97:AddCommandWaitForIdle(true)	    
	UA97:AddCommandMove(GetPosition("zitalinksOben1_Weg4"), true)
    UA97:AddCommandWaitForIdle(true)	    
	UA97:AddCommandMove(GetPosition("zitalinksOben1_Weg5"), true)
    UA97:AddCommandWaitForIdle(true)	    
	UA97:AddCommandMove(GetPosition("Burg2"), true)
    UA97:AddCommandWaitForIdle(true)
    UA97:AddCommandMove(GetPosition("Burg1"), true)
    UA97:AddCommandWaitForIdle(true)	
    UA97:AddCommandMove(GetPosition("zitarechtsOben1"), true)
    UA97:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA97, {
        Position=GetPosition("zitarechtsOben1"),
		Generator = "zitarechtsOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA97)
    for id in UA97:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Der Ganz Obere Teil zita Mitte das End schloss wave1
-----

function createarmy98()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA98 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA98:AddCommandMove(GetPosition("zitalOben1_Weg1"), true)
    UA98:AddCommandWaitForIdle(true)
    UA98:AddCommandMove(GetPosition("zitalOben1_Weg2"), true)
    UA98:AddCommandWaitForIdle(true)
	UA98:AddCommandMove(GetPosition("zitalOben1_Weg3"), true)
    UA98:AddCommandWaitForIdle(true)	    	    
	UA98:AddCommandMove(GetPosition("Burg2"), true)
    UA98:AddCommandWaitForIdle(true)
    UA98:AddCommandMove(GetPosition("Burg1"), true)
    UA98:AddCommandWaitForIdle(true)	
    UA98:AddCommandMove(GetPosition("zitaOben1"), true)
    UA98:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA98, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA98)
    for id in UA98:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss wave2
-----

function createarmy99()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA99 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA99:AddCommandMove(GetPosition("zitalOben1_Weg1"), true)
    UA99:AddCommandWaitForIdle(true)
    UA99:AddCommandMove(GetPosition("zitalOben1_Weg2"), true)
    UA99:AddCommandWaitForIdle(true)
	UA99:AddCommandMove(GetPosition("zitalOben1_Weg3"), true)
    UA99:AddCommandWaitForIdle(true)	    	    
	UA99:AddCommandMove(GetPosition("Burg2"), true)
    UA99:AddCommandWaitForIdle(true)
    UA99:AddCommandMove(GetPosition("Burg1"), true)
    UA99:AddCommandWaitForIdle(true)	
    UA99:AddCommandMove(GetPosition("zitaOben1"), true)
    UA99:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA99, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA99)
    for id in UA99:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss wave3
-----

function createarmy100()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA100 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA100:AddCommandMove(GetPosition("zitalOben1_Weg1"), true)
    UA100:AddCommandWaitForIdle(true)
    UA100:AddCommandMove(GetPosition("zitalOben1_Weg2"), true)
    UA100:AddCommandWaitForIdle(true)
	UA100:AddCommandMove(GetPosition("zitalOben1_Weg3"), true)
    UA100:AddCommandWaitForIdle(true)	    	    
	UA100:AddCommandMove(GetPosition("Burg1"), true)
    UA100:AddCommandWaitForIdle(true)
    UA100:AddCommandMove(GetPosition("Burg2"), true)
    UA100:AddCommandWaitForIdle(true)	
    UA100:AddCommandMove(GetPosition("zitaOben1"), true)
    UA100:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA100, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA100)
    for id in UA100:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss wave4
-----

function createarmy101()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA101 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA101:AddCommandMove(GetPosition("zitalOben1_Weg1"), true)
    UA101:AddCommandWaitForIdle(true)
    UA101:AddCommandMove(GetPosition("zitalOben1_Weg2"), true)
    UA101:AddCommandWaitForIdle(true)
	UA101:AddCommandMove(GetPosition("zitalOben1_Weg3"), true)
    UA101:AddCommandWaitForIdle(true)	    	    
	UA101:AddCommandMove(GetPosition("Burg1"), true)
    UA101:AddCommandWaitForIdle(true)
    UA101:AddCommandMove(GetPosition("Burg2"), true)
    UA101:AddCommandWaitForIdle(true)	
    UA101:AddCommandMove(GetPosition("zitaOben1"), true)
    UA101:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA101, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA101)
    for id in UA101:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss wave 1 attack links
-----

function createarmy102()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA102 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA102:AddCommandMove(GetPosition("zitalOben1_Weg4"), true)
    UA102:AddCommandWaitForIdle(true)
    UA102:AddCommandMove(GetPosition("zitalOben1_Weg5"), true)
    UA102:AddCommandWaitForIdle(true)
	UA102:AddCommandMove(GetPosition("zitalOben1_Weg6"), true)
    UA102:AddCommandWaitForIdle(true)	    	    
	UA102:AddCommandMove(GetPosition("Burg1"), true)
    UA102:AddCommandWaitForIdle(true)
    UA102:AddCommandMove(GetPosition("Burg2"), true)
    UA102:AddCommandWaitForIdle(true)	
    UA102:AddCommandMove(GetPosition("zitaOben1"), true)
    UA102:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA102, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA102)
    for id in UA102:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss wave 1 attack rechts
-----

function createarmy103()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 6 
	elseif gv_difficulty == 2
	then
	LeaderCount = 11 
	end	
    UA103 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA103:AddCommandMove(GetPosition("zitalOben1_Weg7"), true)
    UA103:AddCommandWaitForIdle(true)
    UA103:AddCommandMove(GetPosition("zitalOben1_Weg8"), true)
    UA103:AddCommandWaitForIdle(true)
	UA103:AddCommandMove(GetPosition("zitalOben1_Weg9"), true)
    UA103:AddCommandWaitForIdle(true)	    	    
	UA103:AddCommandMove(GetPosition("Burg2"), true)
    UA103:AddCommandWaitForIdle(true)
    UA103:AddCommandMove(GetPosition("Burg1"), true)
    UA103:AddCommandWaitForIdle(true)	
    UA103:AddCommandMove(GetPosition("zitaOben1"), true)
    UA103:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA103, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
		    {LeaderType=Entities.PU_LeaderSword4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PV_Cannon3, SoldierNum=0, SpawnNum=1, Looped=true},
            {LeaderType=Entities.PV_Cannon4, SoldierNum=0, SpawnNum=1, Looped=true},
			{LeaderType=Entities.PU_LeaderPoleArm4, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA103)
    for id in UA103:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss deff
-----

function createarmy104()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA104 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA104:AddCommandMove(GetPosition("zitalOben1_Weg9"), true)
    UA104:AddCommandWaitForIdle(true)
    UA104:AddCommandMove(GetPosition("zitalOben1_Weg10"), true)
    UA104:AddCommandWaitForIdle(true)
    UA104:AddCommandMove(GetPosition("zitaOben1"), true)
    UA104:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA104, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
			{LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA104)
    for id in UA104:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss deff
-----

function createarmy105()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA105 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA105:AddCommandMove(GetPosition("zitalOben1_Weg9"), true)
    UA105:AddCommandWaitForIdle(true)
    UA105:AddCommandMove(GetPosition("zitalOben1_Weg10"), true)
    UA105:AddCommandWaitForIdle(true)
    UA105:AddCommandMove(GetPosition("zitaOben1"), true)
    UA105:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA105, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
			{LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA105)
    for id in UA105:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss deff
-----

function createarmy106()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA106 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA106:AddCommandMove(GetPosition("zitalOben1_Weg11"), true)
    UA106:AddCommandWaitForIdle(true)
    UA106:AddCommandMove(GetPosition("zitalOben1_Weg12"), true)
    UA106:AddCommandWaitForIdle(true)
    UA106:AddCommandMove(GetPosition("zitaOben1"), true)
    UA106:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA106, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
			{LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA106)
    for id in UA106:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Der Ganz Obere Teil zita Mitte das End schloss deff
-----

function createarmy107()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 1 
	elseif gv_difficulty == 2
	then
	LeaderCount = 3 
	end	
    UA107 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA107:AddCommandMove(GetPosition("zitalOben1_Weg11"), true)
    UA107:AddCommandWaitForIdle(true)
    UA107:AddCommandMove(GetPosition("zitalOben1_Weg12"), true)
    UA107:AddCommandWaitForIdle(true)
    UA107:AddCommandMove(GetPosition("zitaOben1"), true)
    UA107:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA107, {
        Position=GetPosition("zitaOben1"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=3,
        SpawnLeaders=3,
        LeaderDesc={
			{LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA107)
    for id in UA107:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

--------------------  sobald die oberen 2 festungen dead sind

-----
---  Wave 1 hinterhalt
-----

function createarmy108()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA108 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA108:AddCommandMove(GetPosition("Hinterhalt_Weg1"), true)
    UA108:AddCommandWaitForIdle(true)
    UA108:AddCommandMove(GetPosition("Hinterhalt_Weg2"), true)
    UA108:AddCommandWaitForIdle(true)
	UA108:AddCommandMove(GetPosition("Hinterhalt_Weg3"), true)
    UA108:AddCommandWaitForIdle(true)
	UA108:AddCommandMove(GetPosition("Burg1"), true)
    UA108:AddCommandWaitForIdle(true)
	UA108:AddCommandMove(GetPosition("Burg2"), true)
    UA108:AddCommandWaitForIdle(true)
	UA108:AddCommandMove(GetPosition("Hinterhalt_Weg0"), true)
    UA108:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA108, {
        Position=GetPosition("Hinterhalt_Weg0"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=20,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA108)
    for id in UA108:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Wave 2 hinterhalt
-----

function createarmy109()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA109 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA109:AddCommandMove(GetPosition("Hinterhalt_Weg4"), true)
    UA109:AddCommandWaitForIdle(true)
    UA109:AddCommandMove(GetPosition("Hinterhalt_Weg5"), true)
    UA109:AddCommandWaitForIdle(true)
	UA109:AddCommandMove(GetPosition("Hinterhalt_Weg6"), true)
    UA109:AddCommandWaitForIdle(true)
	UA109:AddCommandMove(GetPosition("Burg2"), true)
    UA109:AddCommandWaitForIdle(true)
	UA109:AddCommandMove(GetPosition("Burg1"), true)
    UA109:AddCommandWaitForIdle(true)
	UA109:AddCommandMove(GetPosition("Hinterhalt_Weg7"), true)
    UA109:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA109, {
        Position=GetPosition("Hinterhalt_Weg7"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=20,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA109)
    for id in UA109:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Wave 3 hinterhalt
-----

function createarmy110()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA110 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA110:AddCommandMove(GetPosition("Hinterhalt_Weg9"), true)
    UA110:AddCommandWaitForIdle(true)
    UA110:AddCommandMove(GetPosition("Hinterhalt_Weg10"), true)
    UA110:AddCommandWaitForIdle(true)
	UA110:AddCommandMove(GetPosition("Burg2"), true)
    UA110:AddCommandWaitForIdle(true)
	UA110:AddCommandMove(GetPosition("Burg1"), true)
    UA110:AddCommandWaitForIdle(true)
	UA110:AddCommandMove(GetPosition("Hinterhalt_Weg8"), true)
    UA110:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA110, {
        Position=GetPosition("Hinterhalt_Weg8"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=20,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA110)
    for id in UA110:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Wave 4 hinterhalt
-----

function createarmy111()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA111 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
    UA111:AddCommandMove(GetPosition("Hinterhalt_Weg12"), true)
    UA111:AddCommandWaitForIdle(true)
    UA111:AddCommandMove(GetPosition("Hinterhalt_Weg13"), true)
    UA111:AddCommandWaitForIdle(true)
	UA111:AddCommandMove(GetPosition("Burg1"), true)
    UA111:AddCommandWaitForIdle(true)
	UA111:AddCommandMove(GetPosition("Burg2"), true)
    UA111:AddCommandWaitForIdle(true)
	UA111:AddCommandMove(GetPosition("Hinterhalt_Weg11"), true)
    UA111:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA111, {
        Position=GetPosition("Hinterhalt_Weg11"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=20,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderBow4, SoldierNum=8, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA111)
    for id in UA111:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  Wave 4 hinterhalt
-----

function createarmy112()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA112 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA112:AddCommandMove(GetPosition("Burg1"), true)
    UA112:AddCommandWaitForIdle(true)
	UA112:AddCommandMove(GetPosition("Burg2"), true)
    UA112:AddCommandWaitForIdle(true)
	UA112:AddCommandMove(GetPosition("Hinterhalt_Weg14"), true)
    UA112:AddCommandWaitForIdle(true)	
    UnlimitedArmySpawnGenerator:New(UA112, {
        Position=GetPosition("Hinterhalt_Weg14"),
		Generator = "zitaOben", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=30,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA112)
    for id in UA112:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


-----
---  Hilfstruppe vom verbündeten
-----

function createarmy113()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA113 = UnlimitedArmy:New {
        Player             = 5,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA113:AddCommandMove(GetPosition("Weg1"), true)
    UA113:AddCommandWaitForIdle(true)
	UA113:AddCommandMove(GetPosition("Weg1000"), true)
    UA113:AddCommandWaitForIdle(true)
	UA113:AddCommandMove(GetPosition("Kirche_1_p5"), true)
    UA113:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA113, {
        Position=GetPosition("Kirche_1_p5"),
		Generator = "Turm_p5", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=30,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA113)
    for id in UA113:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  2 armmes
-----

function createarmy114()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA114 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA114:AddCommandMove(GetPosition("Burg1"), true)
    UA114:AddCommandWaitForIdle(true)
	UA114:AddCommandMove(GetPosition("Burg2"), true)
    UA114:AddCommandWaitForIdle(true)
	UA114:AddCommandMove(GetPosition("H701"), true)
    UA114:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA114, {
        Position=GetPosition("H701"),
		Generator = "H700", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA114)
    for id in UA114:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  1 armmes
-----

function createarmy115()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA115 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA115:AddCommandMove(GetPosition("Burg2"), true)
    UA115:AddCommandWaitForIdle(true)
	UA115:AddCommandMove(GetPosition("Burg1"), true)
    UA115:AddCommandWaitForIdle(true)
	UA115:AddCommandMove(GetPosition("H801"), true)
    UA115:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA115, {
        Position=GetPosition("H801"),
		Generator = "H800", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA115)
    for id in UA115:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  3 armmes
-----

function createarmy116()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA116 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA116:AddCommandMove(GetPosition("Burg2"), true)
    UA116:AddCommandWaitForIdle(true)
	UA116:AddCommandMove(GetPosition("Burg1"), true)
    UA116:AddCommandWaitForIdle(true)
	UA116:AddCommandMove(GetPosition("H901"), true)
    UA116:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA116, {
        Position=GetPosition("H901"),
		Generator = "H900", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA116)
    for id in UA116:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

-----
---  3 armmes
-----

function createarmy117()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 2 
	elseif gv_difficulty == 2
	then
	LeaderCount = 5
	end	
    UA117 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 10000,
        AutoRotateRange    = 10000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA117:AddCommandMove(GetPosition("Burg1"), true)
    UA117:AddCommandWaitForIdle(true)
	UA117:AddCommandMove(GetPosition("Burg2"), true)
    UA117:AddCommandWaitForIdle(true)
	UA117:AddCommandMove(GetPosition("H1001"), true)
    UA117:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA117, {
        Position=GetPosition("H1001"),
		Generator = "H1000", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderHeavyCavalry2, SoldierNum=4, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA117)
    for id in UA117:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end


---- 118

function createarmy118()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 5 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7
	end	
    UA118 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA118:AddCommandMove(GetPosition("Zita_1_Weg1"), true)
    UA118:AddCommandWaitForIdle(true)
	UA118:AddCommandMove(GetPosition("Zita_1_Weg2"), true)
    UA118:AddCommandWaitForIdle(true)
	UA118:AddCommandMove(GetPosition("Zita_1_Insel_1"), true)
    UA118:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA118, {
        Position=GetPosition("Zita_1_Insel_1"),
		Generator = "Zita_1_Insel", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=8, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA118)
    for id in UA118:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end

function createarmy119()
    local LeaderCount 
	if gv_difficulty == 1
	then
	LeaderCount = 5 
	elseif gv_difficulty == 2
	then
	LeaderCount = 7
	end	
    UA119 = UnlimitedArmy:New {
        Player             = 6,
        Area               = 4000,
        AutoRotateRange    = 4000,
        Formation          = UnlimitedArmy.Formations.Chaotic,
        LeaderFormation    = FormationFunktion, ---
        AIActive           = true,
        AutoDestroyIfEmpty = false,
        IgnoreFleeing      = false,		
    }
	UA119:AddCommandMove(GetPosition("Zita2_rechts_Weg2"), true)
    UA119:AddCommandWaitForIdle(true)
	UA119:AddCommandMove(GetPosition("Zita2_rechts_Weg1"), true)
    UA119:AddCommandWaitForIdle(true)
	UA119:AddCommandMove(GetPosition("Zita2_rechts1_1"), true)
    UA119:AddCommandWaitForIdle(true)
    UnlimitedArmySpawnGenerator:New(UA119, {
        Position=GetPosition("Zita2_rechts1_1"),
		Generator = "Zita2_rechts1", 		-- wenn das hier tot ist, wird nix mehr gespawnt
        ArmySize=LeaderCount,	
        SpawnCounter=10,
        SpawnLeaders=2,
        LeaderDesc={
		    {LeaderType=Entities.CU_VeteranMajor, SoldierNum=0, SpawnNum=1, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.PU_LeaderRifle2, SoldierNum=8, SpawnNum=3, Looped=true, Experience=VERYHIGH_EXPERIENCE},
			{LeaderType=Entities.CU_VeteranCaptain, SoldierNum=0, SpawnNum=2, Looped=true, Experience=VERYHIGH_EXPERIENCE},
            {LeaderType=Entities.PU_LeaderRifle1, SoldierNum=4, SpawnNum=8, Looped=true, Experience=VERYHIGH_EXPERIENCE},
        },
    })
	function KillAllLeadersWithNoSoldiers(UA119)
    for id in UA119:Iterator(true) do
        if IsAlive(id) then
            if Logic.LeaderGetNumberOfSoldiers(id)==0 then
                SetHealth(id, 0)
            end
        end
    end
end
end



FormationFunktion = function(self, truppid)
	if Logic.IsEntityInCategory(truppid, EntityCategories.Cannon)==1 then
		return 4
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Hero)==1 then
		return 4
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.CavalryHeavy)==1 then
		return 4, 1
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.CavalryLight)==1 then
		return 4, 1
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Bow)==1 or Logic.IsEntityInCategory(truppid, EntityCategories.Rifle)==1 then
		return 4, 1
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Spear)==1 then
		return 3, 1
	end
	if Logic.IsEntityInCategory(truppid, EntityCategories.Sword)==1 then
		return 4, 1
	end
	return 1
end

---------------

-- diese Funktion übergibt die Leibi an Player1
function ChangeLeibi()
	ChangePlayer ("Leibi1",1) 
	ChangePlayer ("Leibi2",1) 
	ChangePlayer ("Leibi3",1) 
	ChangePlayer ("Leibi4",1) 
	ChangePlayer ("hq",1) 
	ChangePlayer ("TU2",1) 
	ChangePlayer ("TU1",1)
end

-- diese Funktion übergibt die Leibi an Player2
function ChangeLeibis()
	ChangePlayer ("Leibi5",2) 
	ChangePlayer ("Leibi6",2) 
	ChangePlayer ("Leibi7",2) 
	ChangePlayer ("Leibi8",2) 
	ChangePlayer ("hq1",2) 
	ChangePlayer ("TU3",2)
	ChangePlayer ("TU4",2)
end

-- Limit the Technologies here. For example Weathermashine.

function Mission_InitTechnologies()
	for i  = 1, 2 do
	ForbidTechnology( Technologies.T_MakeSnow, i)
	ForbidTechnology( Technologies.T_MakeSummer, i)
	ForbidTechnology( Technologies.T_MakeRain, i)
	ForbidTechnology( Technologies.T_ChangeWeather, i)
	ForbidTechnology( Technologies.T_WeatherForecast, i)
	ForbidTechnology( Technologies.T_ThiefSabotage, i)
    ForbidTechnology( Technologies.UP1_Market, i)
    ForbidTechnology( Technologies.UP1_Market, i)
end 
    for i = 5,8 do
          ResearchTechnology(Technologies.T_BodkinArrow, i)
        ResearchTechnology(Technologies.T_Fletching, i)
        ResearchTechnology(Technologies.T_WoodAging, i)
        ResearchTechnology(Technologies.T_Turnery, i)
        ResearchTechnology(Technologies.T_Masonry, i)
        ResearchTechnology(Technologies.GT_Binocul, i)
        ResearchTechnology(Technologies.GT_Mathematics, i)
        ResearchTechnology(Technologies.T_PaddedArcherArmor, i)
        ResearchTechnology(Technologies.T_LeatherArcherArmor, i)
        ResearchTechnology(Technologies.T_LeatherMailArmor, i)
        ResearchTechnology(Technologies.T_SoftArcherArmor, i)
        ResearchTechnology(Technologies.T_ChainMailArmor, i)
        ResearchTechnology(Technologies.T_PlateMailArmor, i)
        ResearchTechnology(Technologies.T_MasterOfSmithery, i)
        ResearchTechnology(Technologies.T_IronCasting, i)
        ResearchTechnology(Technologies.T_BetterTrainingArchery, i)
        ResearchTechnology(Technologies.T_Research_Shoeing, i)
        ResearchTechnology(Technologies.T_BetterTrainingBarracks, i)		
		ResearchTechnology(Technologies.T_FleeceArmor, i)
	    ResearchTechnology(Technologies.T_Sights, i)
		ResearchTechnology(Technologies.T_LeadShot, i)
		ResearchTechnology(Technologies.T_FleeceLinedLeatherArmor, i)
end
end


-- Holzstapel

function CreateWoodPile( _posEntity, _resources )
	assert( type( _posEntity ) == "string" );
	assert( type( _resources ) == "number" );
	gvWoodPiles = gvWoodPiles or {
		JobID = StartSimpleJob("ControlWoodPiles"),
	};
	local pos = GetPosition( _posEntity );
	local pile_id = Logic.CreateEntity( Entities.XD_Rock3, pos.X, pos.Y, 0, 0 );

	SetEntityName( pile_id, _posEntity.."_WoodPile" );

	local newE = ReplaceEntity( _posEntity, Entities.XD_ResourceTree );
	Logic.SetModelAndAnimSet(newE, Models.XD_SignalFire1);
	Logic.SetResourceDoodadGoodAmount( GetEntityId( _posEntity ), _resources*10 );
	Logic.SetModelAndAnimSet(pile_id, Models.Effects_XF_ChopTree);
	table.insert( gvWoodPiles, { ResourceEntity = _posEntity, PileEntity = _posEntity.."_WoodPile", ResourceLimit = _resources*9 } );
end

function ControlWoodPiles()
	for i = table.getn( gvWoodPiles ),1,-1 do
		if Logic.GetResourceDoodadGoodAmount( GetEntityId( gvWoodPiles[i].ResourceEntity ) ) <= gvWoodPiles[i].ResourceLimit then
			DestroyWoodPile( gvWoodPiles[i], i );
		end
	end
end

function DestroyWoodPile( _piletable, _index )
	local pos = GetPosition( _piletable.ResourceEntity );
	DestroyEntity( _piletable.ResourceEntity );
	DestroyEntity( _piletable.PileEntity );
	Logic.CreateEffect( GGL_Effects.FXCrushBuilding, pos.X, pos.Y, 0 );
	table.remove( gvWoodPiles, _index )
end

function ActivateShareExploration(_player1, _player2, _both) --_both auf false setzen, wenn nur einer sehen soll, was der andere treibt (Spion)
	assert(type(_player1) == "number" and type(_player2) == "number" and _player1 <= 8 and _player2 <= 8 and _player1 >= 1 and _player2 >= 1);
	if _both == false then
		Logic.SetShareExplorationWithPlayerFlag(_player1, _player2, 1);
	else
		Logic.SetShareExplorationWithPlayerFlag(_player1, _player2, 1);
		Logic.SetShareExplorationWithPlayerFlag(_player2, _player1, 1);
	end
end
 
function DeactivateShareExploration(_player1, _player2, _both) --_both auf false setzen, wenn nur einer nicht sehen soll, was der andere treibt
	assert(type(_player1) == "number" and type(_player2) == "number" and _player1 <= 8 and _player2 <= 8 and _player1 >= 1 and _player2 >= 1);
	if _both == false then
		Logic.SetShareExplorationWithPlayerFlag(_player1, _player2, 0);
	else
		Logic.SetShareExplorationWithPlayerFlag(_player1, _player2, 0);
		Logic.SetShareExplorationWithPlayerFlag(_player2, _player1, 0);
	end
end

function Umlaute( _text )
	local texttype = type( _text );
	if texttype == "string" then
		_text = string.gsub( _text, "ä", "\195\164" );
		_text = string.gsub( _text, "ö", "\195\182" );
		_text = string.gsub( _text, "ü", "\195\188" );
		_text = string.gsub( _text, "ß", "\195\159" );
		_text = string.gsub( _text, "Ä", "\195\132" );
		_text = string.gsub( _text, "Ö", "\195\150" );
		_text = string.gsub( _text, "Ü", "\195\156" );
		return _text;
	elseif texttype == "table" then
		for k,v in _text do
			_text[k] = Umlaute( v );
		end
		return _text;
	else
		return _text;
	end
end

function GetEntityIdInArea(_playerID, _entity, _position, _range)
    local data = {Logic.GetPlayerEntitiesInArea(_playerID, _entity, _position.X, _position.Y, _range, 1)}
 
    if Logic.IsBuilding(data[2]) then
        if Logic.IsConstructionComplete(data[2]) == 1 then
            return data[2]
        else
            return false
        end
    end
 
    return data[2]
end

-------------------------


